/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer.tree;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.modules.php.project.connections.ui.transfer.tree.CheckRenderer;
import org.netbeans.modules.php.project.connections.ui.transfer.tree.TransferSelectorModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

final class CheckListener
implements MouseListener,
KeyListener {
    private final TransferSelectorModel model;

    public CheckListener(TransferSelectorModel model) {
        assert (model != null);
        this.model = model;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int y;
        JTree tree = (JTree)e.getSource();
        Point p = e.getPoint();
        int x = e.getX();
        int row = tree.getRowForLocation(x, y = e.getY());
        TreePath path = tree.getPathForRow(row);
        if (path == null) {
            return;
        }
        Node node = Visualizer.findNode((Object)path.getLastPathComponent());
        if (node == null) {
            return;
        }
        Rectangle chRect = CheckRenderer.getCheckBoxRectangle();
        Rectangle rowRect = tree.getPathBounds(path);
        chRect.setLocation(chRect.x + rowRect.x, chRect.y + rowRect.y);
        if (e.getClickCount() == 1 && chRect.contains(p)) {
            boolean isSelected = this.model.isNodeSelected(node);
            this.model.setNodeSelected(node, !isSelected);
            tree.repaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == ' ') {
            JTree tree = (JTree)e.getSource();
            TreePath path = tree.getSelectionPath();
            if (path == null) {
                return;
            }
            Node node = Visualizer.findNode((Object)path.getLastPathComponent());
            if (node == null) {
                return;
            }
            boolean isSelected = this.model.isNodeSelected(node);
            this.model.setNodeSelected(node, !isSelected);
            tree.repaint();
            e.consume();
        }
    }
}

