/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.transform;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.modules.xml.actions.InputOutputReporter;
import org.netbeans.modules.xml.lib.FileUtilities;
import org.netbeans.modules.xml.lib.GuiUtil;
import org.netbeans.modules.xsl.actions.TransformAction;
import org.netbeans.modules.xsl.settings.TransformHistory;
import org.netbeans.modules.xsl.transform.TransformServlet;
import org.netbeans.modules.xsl.ui.TransformPanel;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXException;

public class TransformPerformer {
    private InputOutputReporter cookieObserver = null;
    private Node[] nodes;
    private volatile boolean stalled = false;
    private volatile boolean active = false;

    public TransformPerformer(Node[] nodes) {
        this.nodes = nodes;
    }

    private void saveBeforeTransformation(DataObject dObject) {
        SaveCookie save;
        if (dObject.isModified() && (save = (SaveCookie)dObject.getCookie(SaveCookie.class)) != null) {
            try {
                save.save();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        if (this.stalled) {
            throw new IllegalStateException();
        }
        try {
            if (this.nodes.length == 2) {
                DataObject do1 = (DataObject)this.nodes[0].getCookie(DataObject.class);
                boolean xslt1 = TransformUtil.isXSLTransformation(do1);
                DataObject do2 = (DataObject)this.nodes[1].getCookie(DataObject.class);
                boolean xslt2 = TransformUtil.isXSLTransformation(do2);
                this.saveBeforeTransformation(do1);
                this.saveBeforeTransformation(do2);
                if (xslt1 != xslt2) {
                    DataObject xslDO;
                    DataObject xmlDO;
                    TransformableCookie transformable;
                    if (xslt1) {
                        transformable = (TransformableCookie)this.nodes[1].getCookie(TransformableCookie.class);
                        xmlDO = do2;
                        xslDO = do1;
                    } else {
                        transformable = (TransformableCookie)this.nodes[0].getCookie(TransformableCookie.class);
                        xmlDO = do1;
                        xslDO = do2;
                    }
                    DoublePerformer performer = new DoublePerformer(transformable, xmlDO, xslDO);
                    performer.perform();
                } else {
                    TransformableCookie transformable1 = (TransformableCookie)this.nodes[0].getCookie(TransformableCookie.class);
                    SinglePerformer performer = new SinglePerformer(transformable1, do1, xslt1);
                    performer.setLastInBatch(false);
                    performer.perform();
                    TransformableCookie transformable2 = (TransformableCookie)this.nodes[1].getCookie(TransformableCookie.class);
                    performer = new SinglePerformer(transformable2, do2, xslt2);
                    performer.perform();
                }
            } else {
                for (int i = 0; i < this.nodes.length; ++i) {
                    DataObject dataObject = (DataObject)this.nodes[i].getCookie(DataObject.class);
                    this.saveBeforeTransformation(dataObject);
                    TransformableCookie transformable = null;
                    boolean xslt = TransformUtil.isXSLTransformation(dataObject);
                    if (!xslt) {
                        transformable = (TransformableCookie)this.nodes[i].getCookie(TransformableCookie.class);
                    }
                    SinglePerformer performer = new SinglePerformer(transformable, dataObject, xslt);
                    performer.setLastInBatch(i == this.nodes.length - 1);
                    performer.perform();
                }
            }
        }
        finally {
            this.stalled = true;
            this.active = false;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private InputOutputReporter getCookieObserver() {
        if (this.cookieObserver == null) {
            String label = NbBundle.getMessage(TransformPerformer.class, (String)"PROP_transformation_io_name");
            this.cookieObserver = new InputOutputReporter(label);
        }
        return this.cookieObserver;
    }

    private class DoublePerformer
    extends AbstractPerformer {
        public DoublePerformer(TransformableCookie transformable, DataObject xmlDO, DataObject xslDO) {
            super(transformable);
            this.xmlDO = xmlDO;
            this.xslDO = xslDO;
        }

        @Override
        protected void init() throws IOException {
            this.baseFO = this.xmlDO.getPrimaryFile();
            this.baseURL = this.preferFileURL(this.baseFO);
        }

        @Override
        protected void storeData() {
            this.updateHistory(this.xmlDO, false);
            this.updateHistory(this.xslDO, true);
        }
    }

    private class SinglePerformer
    extends AbstractPerformer {
        private DataObject dataObject;
        private boolean xslt;

        public SinglePerformer(TransformableCookie transformable, DataObject dataObject, boolean xslt) {
            super(transformable);
            this.dataObject = dataObject;
            this.xslt = xslt;
        }

        @Override
        protected void init() throws IOException {
            this.baseFO = this.dataObject.getPrimaryFile();
            this.baseURL = this.preferFileURL(this.baseFO);
            if (this.xslt) {
                this.xmlDO = null;
                this.xmlStylesheetSource = null;
                this.xslDO = this.dataObject;
            } else {
                this.xmlDO = this.dataObject;
                this.xmlStylesheetSource = TransformUtil.getAssociatedStylesheet(this.baseURL);
                this.xslDO = null;
            }
        }

        @Override
        protected void storeData() {
            this.updateHistory(this.dataObject, this.xslt);
        }
    }

    private abstract class AbstractPerformer
    extends WindowAdapter
    implements ActionListener {
        private TransformableCookie transformableCookie;
        protected DataObject xmlDO;
        protected Source xmlStylesheetSource;
        protected DataObject xslDO;
        protected FileObject baseFO;
        protected URL baseURL;
        private Source xmlSource;
        private Source xslSource;
        private FileObject resultFO;
        private TransformPanel transformPanel;
        private DialogDescriptor dialogDescriptor;
        private Dialog dialog;
        private TransformPanel.Data data;
        private boolean last = true;
        private Object okOption;
        private boolean workaround31850 = true;

        public AbstractPerformer(TransformableCookie transformable) {
            this.transformableCookie = transformable;
        }

        public final void perform() {
            block2: {
                try {
                    this.init();
                    this.showDialog();
                }
                catch (IOException exc) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)exc.getLocalizedMessage(), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (!this.isLastInBatch()) break block2;
                    TransformPerformer.this.active = false;
                }
            }
        }

        protected abstract void init() throws IOException;

        protected abstract void storeData();

        private void showDialog() throws IOException {
            String xmlStylesheetName = null;
            if (this.xmlStylesheetSource != null) {
                xmlStylesheetName = this.xmlStylesheetSource.getSystemId();
            }
            this.transformPanel = new TransformPanel(this.xmlDO, xmlStylesheetName, this.xslDO);
            Object[] options = new JButton[]{new JButton(NbBundle.getMessage(TransformPerformer.class, (String)"LBL_GoTransform")), new JButton(NbBundle.getMessage(TransformPerformer.class, (String)"LBL_Cancel"))};
            this.okOption = options[0];
            this.dialogDescriptor = new DialogDescriptor((Object)this.transformPanel, NbBundle.getMessage(TransformPerformer.class, (String)"NAME_transform_panel_title"), true, options, (Object)options[0], 0, new HelpCtx(TransformAction.class), null);
            class L
            implements ChangeListener {
                final /* synthetic */ JButton[] val$options;

                L() {
                    this.val$options = jButtonArray;
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    this.val$options[0].setEnabled(AbstractPerformer.this.transformPanel.isInputValid());
                }
            }
            L l = new L();
            this.transformPanel.setChangeListener(l);
            ((AbstractButton)options[0]).setEnabled(this.transformPanel.isInputValid());
            this.dialogDescriptor.setClosingOptions(options);
            this.dialogDescriptor.setButtonListener((ActionListener)this);
            this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
            this.dialog.addWindowListener(this);
            this.dialog.show();
        }

        protected void prepareData() throws IOException, FileStateInvalidException, MalformedURLException, ParserConfigurationException, SAXException {
            this.data = this.transformPanel.getData();
            try {
                this.xmlSource = TransformUtil.createSource(this.baseURL, this.data.getInput());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(TransformPerformer.class, (String)"MSG_sourceError"));
                throw ex;
            }
            if (this.data.getXSL() != null) {
                try {
                    this.xslSource = TransformUtil.createSource(this.baseURL, this.data.getXSL());
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(TransformPerformer.class, (String)"MSG_transError"));
                    throw ex;
                }
            } else {
                this.xslSource = this.xmlStylesheetSource;
            }
            if (this.data.getOutput() != null) {
                String fileName = this.data.getOutput().toString().replace('\\', '/');
                try {
                    this.resultFO = FileUtilities.createFileObject((FileObject)this.baseFO.getParent(), (String)fileName, (boolean)this.data.isOverwriteOutput());
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(TransformPerformer.class, (String)"MSG_resultError"));
                    throw ex;
                }
            }
        }

        protected void updateHistory(DataObject dataObject, boolean xslt) {
            FileObject fileObject = dataObject.getPrimaryFile();
            TransformHistory history = (TransformHistory)fileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (history == null) {
                history = new TransformHistory();
            }
            String outputStr = null;
            if (this.data.getOutput() != null) {
                outputStr = this.data.getOutput().toString();
            }
            if (xslt) {
                history.addXML(this.data.getInput(), outputStr);
            } else {
                history.addXSL(this.data.getXSL(), outputStr);
            }
            history.setOverwriteOutput(this.data.isOverwriteOutput());
            history.setProcessOutput(this.data.getProcessOutput());
            try {
                fileObject.setAttribute("org.netbeans.modules.xsl.settings.TransformHistory", (Object)history);
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
        }

        private void previewOutput() throws MalformedURLException, UnknownHostException {
            TransformServlet.prepare(this.transformableCookie, this.xmlSource, this.xslSource);
            this.showURL(TransformServlet.getServletURL());
        }

        private void fileOutput() throws IOException, FileStateInvalidException, TransformerException {
            OutputStream outputStream = null;
            FileLock fileLock = null;
            try {
                fileLock = this.resultFO.lock();
                outputStream = this.resultFO.getOutputStream(fileLock);
                StreamResult outputResult = new StreamResult(outputStream);
                String xmlName = this.data.getInput();
                String xslName = this.data.getXSL();
                TransformPerformer.this.getCookieObserver().message(NbBundle.getMessage(TransformPerformer.class, (String)"MSG_transformation_1", (Object)xmlName, (Object)xslName));
                TransformUtil.transform(this.xmlSource, this.transformableCookie, this.xslSource, outputResult, (CookieObserver)TransformPerformer.this.getCookieObserver());
            }
            catch (FileAlreadyLockedException exc) {
                throw (FileAlreadyLockedException)ErrorManager.getDefault().annotate((Throwable)exc, NbBundle.getMessage(TransformPerformer.class, (String)"ERR_FileAlreadyLockedException_output"));
            }
            finally {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(1, "Could not close output stream for: " + this.resultFO);
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)this.resultFO);
                dataObject.setValid(false);
            }
            catch (DataObjectNotFoundException dnf) {
                throw new IllegalStateException();
            }
            catch (PropertyVetoException pve) {
                ErrorManager.getDefault().log(1, "Cannot invalidate " + this.resultFO);
            }
            if (this.data.getProcessOutput() == 1) {
                GuiUtil.performDefaultAction((FileObject)this.resultFO);
            } else if (this.data.getProcessOutput() == 2) {
                this.showURL(this.resultFO.getURL());
            }
        }

        private void showURL(URL url) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            GuiUtil.setStatusText((String)NbBundle.getMessage(TransformPerformer.class, (String)"MSG_opening_browser"));
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.workaround31850 = false;
            if (this.okOption == e.getSource()) {
                try {
                    TransformPerformer.this.active = true;
                    this.prepareData();
                    if (this.data.getOutput() != null && this.resultFO == null) {
                        return;
                    }
                    this.dialog.dispose();
                    this.storeData();
                    this.async();
                }
                catch (Exception exc) {
                    ErrorManager.getDefault().notify(16, (Throwable)exc);
                    if (this.isLastInBatch()) {
                        TransformPerformer.this.active = false;
                    }
                }
            } else {
                TransformPerformer.this.active = false;
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            super.windowClosed(e);
            if (this.workaround31850) {
                TransformPerformer.this.active = false;
            }
        }

        private void async() {
            RequestProcessor rp = RequestProcessor.getDefault();
            rp.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (AbstractPerformer.this.data.getOutput() == null) {
                            AbstractPerformer.this.previewOutput();
                        } else {
                            AbstractPerformer.this.fileOutput();
                        }
                    }
                    catch (TransformerException cookieObserver) {
                    }
                    catch (Exception exc) {
                        ErrorManager.getDefault().notify(16, (Throwable)exc);
                    }
                    finally {
                        if (AbstractPerformer.this.isLastInBatch()) {
                            InputOutputReporter cookieObserver = TransformPerformer.this.getCookieObserver();
                            if (cookieObserver != null) {
                                cookieObserver.message(NbBundle.getMessage(TransformPerformer.class, (String)"MSG_transformation_2"));
                                cookieObserver.moveToFront(true);
                            }
                            TransformPerformer.this.active = false;
                        }
                    }
                }
            });
        }

        protected URL preferFileURL(FileObject fileObject) throws MalformedURLException, FileStateInvalidException {
            URL fileURL = null;
            File file = FileUtil.toFile((FileObject)fileObject);
            fileURL = file != null ? file.toURI().toURL() : fileObject.getURL();
            return fileURL;
        }

        public final void setLastInBatch(boolean last) {
            this.last = last;
        }

        public final boolean isLastInBatch() {
            return this.last;
        }
    }
}

