/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.Lexer;

public final class JSType {
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final double INT32_LIMIT = 4.294967296E9;
    private static final long MAX_PRECISE_DOUBLE = 0x20000000000000L;
    private static final long MIN_PRECISE_DOUBLE = -9007199254740992L;

    private JSType() {
    }

    public static boolean isRepresentableAsInt(long l) {
        return (long)((int)l) == l;
    }

    public static boolean isRepresentableAsInt(double d) {
        return (double)((int)d) == d;
    }

    public static boolean isStrictlyRepresentableAsInt(double d) {
        return JSType.isRepresentableAsInt(d) && JSType.isNotNegativeZero(d);
    }

    public static boolean isRepresentableAsInt(Object object) {
        if (object instanceof Number) {
            return JSType.isRepresentableAsInt(((Number)object).doubleValue());
        }
        return false;
    }

    public static boolean isRepresentableAsLong(double d) {
        return (double)((long)d) == d;
    }

    public static boolean isStrictlyRepresentableAsLong(double d) {
        return JSType.isRepresentableAsLong(d) && JSType.isNotNegativeZero(d);
    }

    public static boolean isRepresentableAsLong(Object object) {
        if (object instanceof Number) {
            return JSType.isRepresentableAsLong(((Number)object).doubleValue());
        }
        return false;
    }

    public static boolean isNegativeZero(double d) {
        return d == 0.0 && Double.doubleToRawLongBits(d) == Long.MIN_VALUE;
    }

    private static boolean isNotNegativeZero(double d) {
        return Double.doubleToRawLongBits(d) != Long.MIN_VALUE;
    }

    public static boolean toBoolean(double d) {
        return d != 0.0 && !Double.isNaN(d);
    }

    public static boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d != 0.0 && !Double.isNaN(d);
        }
        if (object instanceof String) {
            return ((String)object).length() > 0;
        }
        return true;
    }

    public static String toString(double d, int n) {
        assert (n >= 2 && n <= 36) : "invalid radix";
        if (JSType.isRepresentableAsInt(d)) {
            return Integer.toString((int)d, n);
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == 0.0) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = d < 0.0;
        double d2 = bl ? -d : d;
        double d3 = Math.floor(d2);
        double d4 = d2 - d3;
        do {
            double d5 = d3 % (double)n;
            stringBuilder.append("0123456789abcdefghijklmnopqrstuvwxyz".charAt((int)d5));
            d3 -= d5;
        } while ((d3 /= (double)n) >= 1.0);
        if (bl) {
            stringBuilder.append('-');
        }
        stringBuilder.reverse();
        if (d4 > 0.0) {
            double d6;
            int n2 = stringBuilder.length();
            stringBuilder.append('.');
            do {
                d6 = Math.floor(d4 *= (double)n);
                stringBuilder.append("0123456789abcdefghijklmnopqrstuvwxyz".charAt((int)d6));
            } while ((d4 -= d6) > 0.0 && stringBuilder.length() - n2 < 1100);
        }
        return stringBuilder.toString();
    }

    public static double toNumber(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return JSType.toNumberGeneric(object);
    }

    public static int digit(char c, int n) {
        return JSType.digit(c, n, false);
    }

    public static int digit(char c, int n, boolean bl) {
        char c2 = (char)(97 + (n - 1) - 10);
        char c3 = Character.toLowerCase(c);
        if (c3 >= 'a' && c3 <= c2) {
            return Character.digit(c, n);
        }
        if (Character.isDigit(c) && (!bl || c >= '0' && c <= '9')) {
            return Character.digit(c, n);
        }
        return -1;
    }

    public static double toNumber(String string) {
        double d;
        boolean bl;
        int n = string.length();
        if (n == 0) {
            return 0.0;
        }
        int n2 = 0;
        char c = string.charAt(0);
        while (Lexer.isJSWhitespace(c)) {
            if (++n2 == n) {
                return 0.0;
            }
            c = string.charAt(n2);
        }
        while (Lexer.isJSWhitespace(string.charAt(n - 1))) {
            --n;
        }
        if (c == '-') {
            if (++n2 == n) {
                return Double.NaN;
            }
            c = string.charAt(n2);
            bl = true;
        } else {
            if (c == '+') {
                if (++n2 == n) {
                    return Double.NaN;
                }
                c = string.charAt(n2);
            }
            bl = false;
        }
        if (n2 + 1 < n && c == '0' && Character.toLowerCase(string.charAt(n2 + 1)) == 'x') {
            d = JSType.parseRadix(string.toCharArray(), n2 + 2, n, 16);
        } else {
            if (c == 'I' && n - n2 == 8 && string.regionMatches(n2, "Infinity", 0, 8)) {
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            for (int i = n2; i < n; ++i) {
                c = string.charAt(i);
                if (c >= '0' && c <= '9' || c == '.' || c == 'e' || c == 'E' || c == '+' || c == '-') continue;
                return Double.NaN;
            }
            try {
                d = Double.parseDouble(string.substring(n2, n));
            }
            catch (NumberFormatException numberFormatException) {
                return Double.NaN;
            }
        }
        return bl ? -d : d;
    }

    public static long toLong(Object object) {
        return object instanceof Long ? (Long)object : JSType.toLong(JSType.toNumber(object));
    }

    public static long toLong(double d) {
        return (long)d;
    }

    public static int toInt32(Object object) {
        return JSType.toInt32(JSType.toNumber(object));
    }

    public static int toInt32(long l) {
        return (int)(l >= -9007199254740992L && l <= 0x20000000000000L ? l : (long)((double)l % 4.294967296E9));
    }

    public static int toInt32(double d) {
        return (int)JSType.doubleToInt32(d);
    }

    public static long toUint32(Object object) {
        return JSType.toUint32(JSType.toNumber(object));
    }

    public static long toUint32(double d) {
        return JSType.doubleToInt32(d) & 0xFFFFFFFFL;
    }

    public static int toUint16(Object object) {
        return JSType.toUint16(JSType.toNumber(object));
    }

    public static int toUint16(int n) {
        return n & 0xFFFF;
    }

    public static int toUint16(long l) {
        return (int)l & 0xFFFF;
    }

    public static int toUint16(double d) {
        return (int)JSType.doubleToInt32(d) & 0xFFFF;
    }

    private static long doubleToInt32(double d) {
        int n = Math.getExponent(d);
        if (n < 31) {
            return (long)d;
        }
        if (n >= 84) {
            return 0L;
        }
        double d2 = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        return (long)(d2 % 4.294967296E9);
    }

    public static boolean isFinite(double d) {
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    private static double parseRadix(char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            if (JSType.digit(cArray[i], n3) == -1) {
                return Double.NaN;
            }
            ++n4;
        }
        if (n4 == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        for (int i = n; i < n + n4; ++i) {
            d *= (double)n3;
            d += (double)JSType.digit(cArray[i], n3);
        }
        return d;
    }

    private static double toNumberGeneric(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof String) {
            return JSType.toNumber((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        return Double.NaN;
    }
}

