/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.menu.VisualDesignerJPanelPopup;

class VisualDesignerPopupFactory
extends PopupFactory {
    public Map<JMenu, JPanel> containerMap = new HashMap<JMenu, JPanel>();
    private Map<JMenu, VisualDesignerJPanelPopup> popupMap = new HashMap<JMenu, VisualDesignerJPanelPopup>();
    private MenuEditLayer canvas;

    public VisualDesignerPopupFactory(MenuEditLayer canvas) {
        this.canvas = canvas;
    }

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        final JMenu menu = (JMenu)owner;
        JPanel cont = this.containerMap.get(menu);
        if (cont == null) {
            cont = new VisualDesignerJPanelContainer(menu, this);
            cont.setLayout(new BoxLayout(cont, 1));
            RADVisualContainer menuRAD = (RADVisualContainer)this.canvas.formDesigner.getMetaComponent(menu);
            for (RADComponent c : menuRAD.getSubBeans()) {
                JComponent comp = (JComponent)this.canvas.formDesigner.getComponent(c);
                cont.add(comp);
            }
            cont.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.containerMap.put(menu, cont);
            this.canvas.layers.add((Component)cont, JLayeredPane.DEFAULT_LAYER);
        }
        cont.setSize(cont.getLayout().preferredLayoutSize(cont));
        this.canvas.validate();
        this.canvas.setVisible(true);
        final JPanel fcont = cont;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualDesignerPopupFactory.this.setLocationFromMenu(menu, fcont);
            }
        });
        this.canvas.validate();
        this.canvas.repaint();
        VisualDesignerJPanelPopup popup = new VisualDesignerJPanelPopup(cont, menu, this);
        this.popupMap.put(menu, popup);
        return popup;
    }

    VisualDesignerJPanelPopup getPopup(JMenu menu) {
        return this.popupMap.get(menu);
    }

    private void setLocationFromMenu(JMenu menu, JPanel cont) {
        Point pt = SwingUtilities.convertPoint(menu, new Point(0, 0), this.canvas);
        JComponent parent = this.canvas.getMenuParent(menu);
        pt = parent instanceof JMenu ? new Point(pt.x + menu.getWidth(), pt.y) : new Point(pt.x, pt.y + menu.getHeight());
        cont.setLocation(pt);
    }

    void hideOtherMenus(JMenu menu) {
        for (JMenu m : this.containerMap.keySet()) {
            if (m == menu || this.isAncestor(m, menu)) continue;
            JPanel popup = this.containerMap.get(m);
            popup.setVisible(false);
        }
    }

    private boolean isAncestor(JMenu m, JMenu menu) {
        return this.canvas.isAncestor(menu, m);
    }

    private static class VisualDesignerJPanelContainer
    extends JPanel {
        private JMenu menu;
        private VisualDesignerPopupFactory fact;

        VisualDesignerJPanelContainer(JMenu menu, VisualDesignerPopupFactory fact) {
            this.menu = menu;
            this.fact = fact;
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                this.fact.hideOtherMenus(this.menu);
                this.fact.setLocationFromMenu(this.menu, this);
            }
            super.setVisible(visible);
        }
    }
}

