/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.AsyncRootNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public final class TopLevelAwaitModuleBodyNode
extends JavaScriptNode {
    private final JSContext context;
    @CompilerDirectives.CompilationFinal
    private volatile CallTarget resumptionTarget;
    @Node.Child
    private JavaScriptNode moduleBodyNode;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncResult;
    @Node.Child
    private volatile DirectCallNode asyncCallNode;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncContextNode;

    private TopLevelAwaitModuleBodyNode(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode asyncResult, JSWriteFrameSlotNode writeAsyncContextNode) {
        this.context = context;
        this.moduleBodyNode = body;
        this.writeAsyncContextNode = writeAsyncContextNode;
        this.writeAsyncResult = asyncResult;
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode asyncContext, JSWriteFrameSlotNode writeAsyncContextNode) {
        return new TopLevelAwaitModuleBodyNode(context, body, asyncContext, writeAsyncContextNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        JSModuleRecord moduleRecord = (JSModuleRecord)JSArguments.getUserArgument(frame.getArguments(), 0);
        MaterializedFrame moduleFrame = moduleRecord.getEnvironment() != null ? moduleRecord.getEnvironment() : frame.materialize();
        PromiseCapabilityRecord promiseCapability = (PromiseCapabilityRecord)JSArguments.getUserArgument(frame.getArguments(), 1);
        if (promiseCapability == null) {
            try {
                return this.moduleBodyNode.execute((VirtualFrame)moduleFrame);
            }
            catch (YieldException e) {
                assert (e.isYield());
                moduleRecord.setEnvironment(moduleFrame);
                return Undefined.instance;
            }
        }
        this.ensureAsyncCallTargetInitialized();
        this.writeAsyncContextNode.executeWrite((VirtualFrame)moduleFrame, AsyncRootNode.createAsyncContext(this.resumptionTarget, promiseCapability, moduleFrame));
        Object unusedInitialResult = null;
        this.asyncCallNode.call(new Object[]{moduleFrame, promiseCapability, unusedInitialResult});
        return promiseCapability.getPromise();
    }

    private boolean asyncCallTargetInitializationRequired() {
        return this.resumptionTarget == null || this.asyncCallNode == null;
    }

    private void ensureAsyncCallTargetInitialized() {
        if (this.asyncCallTargetInitializationRequired()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initializeAsyncCallTarget();
        }
    }

    private void initializeAsyncCallTarget() {
        CompilerAsserts.neverPartOfCompilation();
        this.atomic(() -> {
            if (this.asyncCallTargetInitializationRequired()) {
                TopLevelAwaitModuleRootNode asyncRootNode = new TopLevelAwaitModuleRootNode(this.context, this.moduleBodyNode, this.writeAsyncResult, this.getRootNode().getSourceSection(), "");
                this.resumptionTarget = Truffle.getRuntime().createCallTarget((RootNode)asyncRootNode);
                this.asyncCallNode = (DirectCallNode)this.insert((Node)DirectCallNode.create((CallTarget)this.resumptionTarget));
                this.moduleBodyNode = null;
                this.writeAsyncResult = null;
            }
        });
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return TopLevelAwaitModuleBodyNode.create(this.context, TopLevelAwaitModuleBodyNode.cloneUninitialized(this.moduleBodyNode, materializedTags), TopLevelAwaitModuleBodyNode.cloneUninitialized(this.writeAsyncResult, materializedTags), TopLevelAwaitModuleBodyNode.cloneUninitialized(this.writeAsyncContextNode, materializedTags));
    }

    @NodeInfo(cost=NodeCost.NONE, language="JavaScript")
    public static final class TopLevelAwaitModuleRootNode
    extends JavaScriptRootNode {
        private final JSContext context;
        private final String functionName;
        private final ValueProfile typeProfile = ValueProfile.createClassProfile();
        @Node.Child
        private JavaScriptNode functionBody;
        @Node.Child
        private JSFunctionCallNode callResolveNode;
        @Node.Child
        private JSFunctionCallNode callRejectNode;
        @Node.Child
        private JSWriteFrameSlotNode writeAsyncResult;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        TopLevelAwaitModuleRootNode(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode asyncResult, SourceSection functionSourceSection, String functionName) {
            super(context.getLanguage(), functionSourceSection, null);
            this.context = context;
            this.functionBody = body;
            this.callResolveNode = JSFunctionCallNode.createCall();
            this.functionName = functionName;
            this.writeAsyncResult = asyncResult;
        }

        public Object execute(VirtualFrame frame) {
            MaterializedFrame asyncFrame = JSFrameUtil.castMaterializedFrame(frame.getArguments()[0]);
            PromiseCapabilityRecord promiseCapability = (PromiseCapabilityRecord)frame.getArguments()[1];
            Completion resumptionValue = (Completion)frame.getArguments()[2];
            this.writeAsyncResult.executeWrite((VirtualFrame)asyncFrame, resumptionValue);
            try {
                this.functionBody.execute((VirtualFrame)asyncFrame);
                Object maybeRecord = JSArguments.getUserArgument(asyncFrame.getArguments(), 0);
                assert (maybeRecord instanceof JSModuleRecord);
                JSModuleRecord moduleRecord = (JSModuleRecord)maybeRecord;
                DynamicObject result = this.context.getEvaluator().getModuleNamespace(moduleRecord);
                TopLevelAwaitModuleRootNode.promiseCapabilityResolve(this.callResolveNode, promiseCapability, result);
            }
            catch (YieldException e) {
                assert (e.isAwait());
            }
            catch (Throwable e) {
                if (this.shouldCatch(e)) {
                    TopLevelAwaitModuleRootNode.promiseCapabilityReject(this.callRejectNode, promiseCapability, this.getErrorObjectNode.execute(e));
                }
                throw e;
            }
            return Undefined.instance;
        }

        private boolean shouldCatch(Throwable exception) {
            if (this.getErrorObjectNode == null || this.callRejectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
                this.callRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            }
            return TryCatchNode.shouldCatch(exception, this.typeProfile);
        }

        @Override
        public boolean isResumption() {
            return true;
        }

        public String getName() {
            if (this.functionName != null && !"".equals(this.functionName)) {
                return this.functionName;
            }
            return ":top-level-await-module";
        }

        private static void promiseCapabilityResolve(JSFunctionCallNode promiseCallNode, PromiseCapabilityRecord promiseCapability, Object result) {
            promiseCallNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), result));
        }

        private static void promiseCapabilityReject(JSFunctionCallNode promiseCallNode, PromiseCapabilityRecord promiseCapability, Object result) {
            promiseCallNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), result));
        }
    }
}

