# VMware SVGA

Section "Files"
    FontPath "/usr/X11R6/lib/X11/fonts/misc/"
    RGBPath "/usr/X11R6/lib/X11/rgb"
EndSection

Section "ServerFlags"
#    NoTrapSignals
EndSection

Section "Keyboard"
    Protocol "Standard"
#    ServerNumLock
EndSection

Section "Pointer"
    Protocol "$MOUSE_PROTOCOL"
    Device "$MOUSE_DEVICE"
EndSection

Section "Monitor"
    Identifier "vmware"
    VendorName "VMware"
    ModelName "Virtual Monitor"
#   BandWidth 10000
    HorizSync 1-10000
    VertRefresh 1-10000
    ModeLine "640x480" 100 640 700 800 900 480 500 600 700
    ModeLine "800x600" 100 800 900 1000 1100 600 700 800 900
    ModeLine "1024x768" 100 1024 1100 1200 1300 768 800 900 1000
    ModeLine "1152x864" 100 1152 1200 1300 1400 864 900 1000 1100
    ModeLine "1152x900" 100 1152 1200 1300 1400 900 1000 1100 1200
    ModeLine "1280x1024" 100 1280 1300 1400 1500 1024 1100 1200 1300
    ModeLine "1376x1032" 100 1376 1400 1500 1600 1032 1100 1200 1300
    ModeLine "1600x1200" 100 1600 1700 1800 1900 1200 1300 1400 1500
    ModeLine "2364x1773" 100 2364 2400 2500 2600 1773 1800 1900 2000
EndSection

Section "Device"
    Identifier "SVGA"
    Chipset "generic"
EndSection

Section "Screen"
    Driver "accel"
    Device "SVGA"
    Monitor "vmware"
    Subsection "Display"
#	Modes %SCREEN_MODE%
#	Modes "1600x1200" "1280x1024" "1152x864" "1024x768" "800x600" "640x480"
#	Modes "640x480"
#	Modes "800x600"
#	Modes "1024x768"
#	Modes "1152x864"
#	Modes "1152x900"
#	Modes "1280x1024"
#	Modes "1376x1032"
#	Modes "1600x1200"
	Modes "$SCREEN_RESOLUTION"
        ViewPort 0 0
    EndSubsection
EndSection
