# XF86Config template

Section "Files"

	RgbPath	"/usr/X11R6/lib/X11/rgb"

	FontPath	"/usr/X11R6/lib/X11/fonts/misc"

EndSection


Section "ServerFlags"

    #NoTrapSignals
    #DontZap
    #DontZoom

EndSection


Section "Keyboard"

    Protocol    "Standard"
    #Protocol   "Xqueue"

    AutoRepeat  500 5

    #ServerNumLock

    #Xleds      1 2 3

#    LeftAlt        Meta
#    RightAlt        Meta
#    ScrollLock      Compose
#    RightCtl        Control

#    XkbDisable
#   XkbKeymap     "xfree86(us)"

EndSection


Section "Pointer"
    Protocol    "$MOUSE_PROTOCOL"
    Device      "$MOUSE_DEVICE"

#    Protocol	"Xqueue"

#    BaudRate	9600
#    SampleRate	150

    Emulate3Buttons
    Emulate3Timeout    50

#    ChordMiddle

EndSection


Section "Monitor"

    Identifier  "Unknown"
    VendorName  "Unknown"
    ModelName   "Unknown"

# HorizSync is in kHz unless units are specified.

    HorizSync   $SCREEN_HORIZSYNC
    
# VertRefresh is in Hz unless units are specified.

    VertRefresh $SCREEN_VERTREFRESH


# 512x384 @ 78 Hz, 31.50 kHz hsync
Modeline "512x384"    20.160 512  528  592  640   384  385  388  404 -HSync -VSync
# 512x384 @ 85 Hz, 34.38 kHz hsync
Modeline "512x384"    22     512  528  592  640   384  385  388  404 -HSync -VSync

# 640x400 @ 70 Hz, 31.5 kHz hsync
Modeline "640x400"     25.175 640  664  760  800   400  409  411  450
# 640x400 @ 85 Hz, 37.86 kHz hsync
Modeline "640x400"     31.5   640  672 736   832   400  401  404  445 -HSync +VSync

# 640x480 @ 100 Hz, 53.01 kHz hsync
Modeline "640x480"     45.8   640  672  768  864   480  488  494  530 -HSync -VSync
# 640x480 @ 60 Hz, 31.5 kHz hsync
Modeline "640x480"     25.175 640  664  760  800   480  491  493  525
# 640x480 @ 72 Hz, 36.5 kHz hsync
Modeline "640x480"     31.5   640  680  720  864   480  488  491  521
# 640x480 @ 75 Hz, 37.50 kHz hsync
ModeLine  "640x480"    31.5   640  656  720  840   480  481  484  500 -HSync -VSync
# 640x480 @ 85 Hz, 43.27 kHz hsync
Modeline "640x480"     36     640  696  752  832   480  481  484  509 -HSync -VSync

# 800x600 @ 100 Hz, 64.02 kHz hsync
Modeline  "800x600"    69.65  800  864  928 1088   600  604  610  640 -HSync -VSync
# 800x600 @ 56 Hz, 35.15 kHz hsync
ModeLine "800x600"     36     800  824  896 1024   600  601  603  625
# 800x600 @ 60 Hz, 37.8 kHz hsync
Modeline "800x600"     40     800  840  968 1056   600  601  605  628 +hsync +vsync
# 800x600 @ 72 Hz, 48.0 kHz hsync
Modeline "800x600"     50     800  856  976 1040   600  637  643  666 +hsync +vsync
# 800x600 @ 85 Hz, 55.84 kHz hsync
Modeline  "800x600"    60.75  800  864  928 1088   600  616  621  657 -HSync -VSync

# 1024x480 for certain Vaios
Modeline "1024x480"   65 1024 1032 1176 1344 480 491 493 525 -HSync -VSync

# 1024x768 @ 100Hz, 80.21 kHz hsync
Modeline "1024x768"   115.5  1024 1056 1248 1440  768  771  781  802 -HSync -VSync
# 1024x768 @ 60 Hz, 48.4 kHz hsync
Modeline "1024x768"    65    1024 1032 1176 1344   768  771  777  806 -hsync -vsync
# 1024x768 @ 70 Hz, 56.5 kHz hsync
Modeline "1024x768"    75    1024 1048 1184 1328   768  771  777  806 -hsync -vsync
# 1024x768 @ 76 Hz, 62.5 kHz hsync
Modeline "1024x768"    85    1024 1032 1152 1360   768  784  787  823
# 1024x768 @ 85 Hz, 70.24 kHz hsync
Modeline "1024x768"   98.9  1024 1056 1216 1408   768 782 788 822 -HSync -VSync

ModeLine "1024x768" 44.9 1024 1048 1208 1264 768 776 784 817 +hsync +vsync Interlace


# 1152x864 @ 100 Hz, 89.62 kHz hsync
Modeline "1152x864"   137.65 1152 1184 1312 1536   864  866  885  902 -HSync -VSync
# 1152x864 @ 60 Hz, 53.5 kHz hsync
Modeline  "1152x864"   89.9  1152 1216 1472 1680   864  868  876  892 -HSync -VSync
# 1152x864 @ 70 Hz, 62.4 kHz hsync
Modeline  "1152x864"   92    1152 1208 1368 1474   864  865  875  895
# 1152x864 @ 78 Hz, 70.8 kHz hsync
Modeline "1152x864"   110   1152 1240 1324 1552   864  864  876  908
# 1152x864 @ 84 Hz, 76.0 kHz hsync
Modeline "1152x864"   135    1152 1464 1592 1776   864  864  876  908

# 1280x960 @ 60 HzModeline "1280x960"   108   1280 1376 1488 1800 960 961 964 1000 +HSync +VSync
# 1280x960 @ 85 HzModeline "1280x960"   148.5 1280 1344 1504 1728 960 961 964 1011  +HSync +VSync

# 1280x1024 @ 100 Hz, 107.16 kHz hsync
Modeline "1280x1024"  181.75 1280 1312 1440 1696  1024 1031 1046 1072 -HSync -VSync
# 1280x1024 @ 61 Hz, 64.2 kHz hsync
Modeline "1280x1024"  110    1280 1328 1512 1712  1024 1025 1028 1054
# 1280x1024 @ 70 Hz, 74.59 kHz hsync
Modeline "1280x1024"  126.5 1280 1312 1472 1696  1024 1032 1040 1068 -HSync -VSync
# 1280x1024 @ 74 Hz, 78.85 kHz hsync
Modeline "1280x1024"  135    1280 1312 1456 1712  1024 1027 1030 1064
# 1280x1024 @ 76 Hz, 81.13 kHz hsync
Modeline "1280x1024"  135    1280 1312 1416 1664  1024 1027 1030 1064
# 1280x1024 @ 85 Hz, 91.15 kHz hsync
Modeline "1280x1024"  157.5  1280 1344 1504 1728  1024 1025 1028 1072 +HSync +VSync

# 1600x1200 @ 60Hz, 75.00 kHz hsync
Modeline "1600x1200"  162   1600 1664 1856 2160  1200 1201 1204 1250 +HSync +VSync
# 1600x1200 @ 70 Hz, 87.50 kHz hsync
Modeline "1600x1200"  189    1600 1664 1856 2160  1200 1201 1204 1250 -HSync -VSync
# 1600x1200 @ 75 Hz, 93.75 kHz hsync
Modeline "1600x1200"  202.5  1600 1664 1856 2160  1200 1201 1204 1250 +HSync +VSync
# 1600x1200 @ 85 Hz, 105.77 kHz hsync
Modeline "1600x1200"  220    1600 1616 1808 2080  1200 1204 1207 1244 +HSync +VSync

# 1800x1440 @ 64Hz, 96.15 kHz hsync 
ModeLine "1800X1440"  230    1800 1896 2088 2392 1440 1441 1444 1490 +HSync +VSync
# 1800x1440 @ 70Hz, 104.52 kHz hsync 
ModeLine "1800X1440"  250    1800 1896 2088 2392 1440 1441 1444 1490 +HSync +VSync

EndSection


Section "Device"
    Identifier  "svga"
    VendorName  "Unknown"
    BoardName   "Unknown"
    Option "sw_cursor"
    #VideoRam    2048
EndSection


Section "Screen"
    Driver      "accel"
    Device      "svga"
    Monitor     "Unknown"
    DefaultColorDepth   16
    Subsection "Display"
        Depth       8
        Modes       "$SCREEN_RESOLUTION"
        ViewPort    0 0
    EndSubsection
    Subsection "Display"
        Depth       15
        Modes       "$SCREEN_RESOLUTION"
        ViewPort    0 0
    EndSubsection
    Subsection "Display"
        Depth       16
        Modes       "$SCREEN_RESOLUTION"
        ViewPort    0 0
    EndSubsection
    Subsection "Display"
        Depth       24
        Modes       "$SCREEN_RESOLUTION"
        ViewPort    0 0
    EndSubsection
EndSection

