;***********************************************************************
;
;	module.ini - Module configurations for Citrix ICA Client for Unix
;
;	Copyright 1994-2002 Citrix Systems, Inc. All rights reserved.
;
;***********************************************************************

[WFClient]
Version = 2
EnableSessionSharingHost = True
EnableSessionSharingClient = True
AttemptCrossPlatformSessionReuse = True
DeferredUpdateMode = True

[ICA 3.0]
VirtualDriver = Thinwire3.0, Clipboard, ClientDrive, ClientPrinter, ClientAudio, ClientManagement, ClientComm, TWI, ZL_FONT, ZLC, ICACTL, SmartCard
Thinwire3.0 = On
Clipboard = On
TWI = On
ZLC=On
ZL_FONT=On
ICACTL=On
ClientDrive=On
ClientPrinter=On
ClientAudio=On
ClientManagement=On
ClientComm=On
SmartCard=$SMARTCARD

[TransportDriver]
TCP/IP=

[TCP/IP]
ProtocolSupport = RFrame, Encrypt
RFrame = On
Encrypt = On
TcpNoDelay = No
NameResolverTCP = NRUDP
NameResolverHTTP = NRHTTP
HttpBrowserAddress=
TcpBrowserAddress=
OutBufLength	= 1460

[RFrame]
DriverName = PDRFRAME.DLL

[EncryptionLevelSession]
Basic=Encrypt
RC5 (128 bit - Login Only)=EncRC5-0
RC5 (40 bit)=EncRC5-40
RC5 (56 bit)=EncRC5-56
RC5 (128 bit)=EncRC5-128

[Encrypt]
DriverName=PDCRYPT1.DLL

[EncRC5-0]
;DriverName=PDC0.DLL
DriverName=PDCRYPT2.DLL

[EncRC5-40]
;DriverName=PDC40.DLL
DriverName=PDCRYPT2.DLL

[EncRC5-56]
;DriverName=PDC56.DLL
DriverName=PDCRYPT2.DLL

[EncRC5-128]
;DriverName=PDC128.DLL
DriverName=PDCRYPT2.DLL

[Compress]

[OemFilter]

[Thinwire3.0]
PersistentCacheEnabled = Off
MMExtension1=XFree86-Misc
MMExtensionVal1=Caps Scroll Num

[Clipboard]

[ClientDrive]
MaxWindowSize		  = 6276
MaxRequestSize		  = 1046
CacheTimeout		  = 600
CacheTimeoutHigh	  = 0
CacheTransferSize	  = 0
CacheDisable		  = FALSE
CacheWriteAllocateDisable = FALSE

[ClientPrinter]
WindowSize	= 1024
MaxWindowsSize	= 2048

[ClientAudio]
DriverName = VDCAM.DLL

[AudioConverter]
DriverName=ClientAudCvt

[AudioConverterList]
NumConverters = 1
Converter0 = ADPCMConverter

[ADPCMConverter]
DriverName=ADPCM_Module

[ClientManagement]

[ClientComm]
WindowSize          = 1024
CommPollSize        = Off
CommPollWaitMin     = 1
CommPollWaitMax     = 500
CommPollWaitInc     = 1
CommPollWaitIncTime = 20

[TWI]
DriverName = VDTWIN.DLL

[ZLC]
DriverName = VDZLC.DLL

[ZL_FONT]
DriverName = VDFON30W.DLL

[ICACTL]

[KeyboardLayout]
(User Profile)=0x00000000
(Server Default)=0x0000000F
NL_BE=0x00000813
FR_BE=0x0000080C
PT_BR=0x00000416
EN_GB=0x00000809
Bulgarian=0x00000402
Canadian English (Multilingual)=0x00001009
FR_CA=0x00000C0C
Canadian French (Multilingual)=0x00010C0C
HR=0x0000041A
CS=0x00000405
DA=0x00000406
NL=0x00000413
SV_FI=0x0000040B
FR=0x0000040C
DE=0x00000407
Greek=0x00000408
HU=0x0000040E
Icelandic=0x0000040F
IT=0x00000410
Italian (142)=0x00010410
JA=0xe0010411
Latin American=0x0000080A
NO=0x00000414
EN_NZ=0x00001409
PL=0x00000415
Polish=0x00010415
PT=0x00000816
RO=0x00000418
RU=0x00000419
Slovak=0x0000041B
ET=0x00000425
SL=0x00000424
ES=0x0000040A
Spanish variation=0x0001040A
SV=0x0000041D
FR_CH=0x0000100C
DE_CH=0x00000807
Turkish (F)=0x0001041F
TR=0x0000041F
EN_US=0x00000409
US-Dvorak=0x00010409
EN_IN=0x00020409

[KeyboardType]
(Default)=0x00000000
101 Keyboard (Japanese)=0x000c0007
106 Keyboard (Japanese)=0x020c0007
DEC LK411-JJ Keyboard (Japanese)=0x850c0007
DEC LK411-AJ Keyboard (Japanese)=0x870c0007
IBM PC/XT or compatible=0x000c0004
Japanese Keyboard for 106n (Japanese)=0x860c0007
NEC PC-9800 on PC98-NX (Japanese)=0x810f0007
NEC PC-9800 on PC98-NX 2 (Japanese)=0x820f0007
NEC PC-9800 on Windows 95 and 98 (Japanese)=0x830f0007
NEC PC-9800 on Windows NT (Japanese)=0x840f0007

;**********************************************************************
;**
;** Hotkey lists (UI)
;**
;**********************************************************************

[Hotkey Shift States]
(none)=0
Alt=2560
Ctrl=1280
Shift=3
Alt+Ctrl=3840
Alt+Shift=2563
Ctrl+Shift=1283
Alt+Ctrl+Shift=3843

[Hotkey Keys]
(none)=0
F1=112
F2=113
F3=114
F4=115
F5=116
F6=117
F7=118
F8=119
F9=120
F10=121
F11=122
F12=123
Minus=105
Plus=106
Tab=16

; note: keep these in step with the lists in setup-netscape.sh and post-update.sh
[File Type Associations]
Microsoft Word=doc,rtf,wri
Microsoft Excel=xls
Microsoft Access=mdb
Microsoft Outlook=oft
Microsoft PowerPoint=ppt
Microsoft Visio=vsd
Microsoft Project=mpp
WinZip Computing=zip

[Browser]
Path=
Command=$ICAROOT/util/nslaunch %s || ${BROWSER:=netscape} %s || firefox %s || mozilla %s
PercentS=4
AcceptURLType=http,https
RejectURLType=

[Player]
Path=
Command=realplay %s
PercentS=1
AcceptURLType=rtsp,rtspu,pnm
RejectURLType=mms

[Codepage_1250]
Upper=41-5a,8a,8c-8f,a3,a5,aa,af,bc,c0-d6,d8-de
Lower=61-7a,9a,9c-9f,b3,b9,ba,bf,be,e0-f6,f8-fe

[SmartCard]
DriverName=VDSCARD.DLL
PCSCLibraryName=libpcsclite.so
PCSCCodePage=0

