# dillorc
# Sample dillo initialization file.
# Copy this file to ~/.dillo/dillorc and edit to your taste.
# Lines that start with a '#' are comments.


#-------------------------------------------------------------------------
#                             FIRST SECTION                             :)
#-------------------------------------------------------------------------

# Set the desired initial browser size
geometry=$SCREEN_RESOLUTION

# Dicache is where the Decompressed Images are cached (not the original ones).
# If you have a lot of memory and a slow CPU, use YES, otherwise use NO
use_dicache=NO


#-------------------------------------------------------------------------
#                           RENDERING SECTION
#-------------------------------------------------------------------------

# Fontname for variable width rendering (most of the text).
#   - some fonts may slow down rendering, some others not!
#   - try to tune a fontname/font_factor combination.
# Ex. {helvetica, lucida, times, "new century schoolbook", utopia, ...}
vw_fontname=helvetica

# Fontname for fixed width rendering (mainly <pre> quoted text)
fw_fontname=courier

# All fontsizes are scaled by this value (default is 1.0)
#font_factor=1.2

# If you prefer oblique over italic fonts, uncoment next line
#use_oblique=YES

# Show tooltip popup for images?
# Note: We use the "title" attribute and not "alt".
#       More info at: http://bugzilla.mozilla.org/show_bug.cgi?id=25537
show_tooltip=YES

# Set this to YES, if you want to limit the word wrap width to the vieport
# width (may be useful for iPAQ)
limit_text_width=NO


#-------------------------------------------------------------------------
#                            NETWORK SECTION
#-------------------------------------------------------------------------

# Set the home location
home="http://www.dillo.org/"

# Set search url to use with "s <keywords>".
# %s is replaced with keywords separated by '+'.
search_url="http://www.google.com/search?q=%s"
#search_url="http://search.lycos.com/default.asp?query=%s"
#search_url="http://www.alltheweb.com/search?cat=web&query=%s"

# Set the proxy information for http
#http_proxy=http://localhost:8080/

# When using a proxy, this sets the domains to access without proxy.
# (separated with a single space -- see examples below)
#no_proxy = ".mynet.com"
#no_proxy = ".mynet.com .other.net .foo.bar.org"


#-------------------------------------------------------------------------
#                            COLORS SECTION
#-------------------------------------------------------------------------

# Here we can use the HTML (standar and extended) or C syntax.

# Set the background color
# bg_color=gray
# bg_color=0xd6d6c0
bg_color=0xdcd1ba

# Set the text color
text_color=black

# Set the link color
link_color=blue

# If your eyes suffer with white backgrounds, or you have headaches after
# lengthy computer sessions, and you don't need high contrast to see sharply,
# uncomment next line (it'll use 'bg_color' instead).   -- It works!
#allow_white_bg=NO

# Use the same colors with all documents?
force_my_colors=NO

# When set to YES, visited links always have a characteristic color,
# independent of the page author's setting.
force_visited_color=YES

#-------------------------------------------------------------------------
#                        USER INTERFACE SECTION
#-------------------------------------------------------------------------

# Size of dillo panel (used to enlarge the browsing area)
# tiny   :  recommended for iPAQ (with small_icons)
# medium :  nice!
# large  :  Traditional
panel_size=medium
small_icons=NO

# Here you can choose to hide some widgets of the dillo panel...
#show_back=NO
#show_forw=NO
#show_home=NO   
#show_reload=NO
#show_save=NO
#show_stop=NO
#show_bookmarks=NO
#show_menubar=NO
#show_clear_url=NO
#show_url=NO
#show_search=NO
#show_progress_box=NO

# Start dillo windows with a hidden panel?
fullwindow_start=NO

# Enabling this will restrain OpenUrl and FindText, but may be required
# for the ION window manager.
transient_dialogs=NO

# When filling forms, our default behaviour is to submit on enterpress,
# but only when there's a single text entry (to avoid incomplete submits).
# OTOH, if you have to fill the same form lots of times, you may find
# useful to keep away from the mouse by forcing enter to submit.
enterpress_forces_submit=NO

# Some forms lack a submit button, and dillo can generate a custom one
# internally. Unfortunately there's no guarantee for it to work. :(
# (my experience is that forms that lack a submit rely on Javascript)
generate_submit=NO

#-------------------------------------------------------------------------
#                        DEBUG MESSAGES SECTION
#-------------------------------------------------------------------------

# The new parser is more accurate detecting HTML errors. 
# Also pages may look better or worst (after all is bad-formed HTML).
# Uncomment this line if you want to use the old parser.
#use_old_parser=YES

# Generic messsages (mainly for debugging specific parts)
# Uncomment the following line to disable them.
#show_msg=NO

# Soon we'll add the "show_debug_messages=NO" option...

# -----------------------------------------------------------------------
# dillorc ends here.
