#! /bin/sh
#
# Mount Hotplug Device
#

. /etc/thinstation.env
. $TS_GLOBAL

if [ `make_caps $USB_STORAGE_SYNC` == "OFF" ] ; then
  sync=""
else
  sync="sync"
fi

options=""
if [ -n $USB_MOUNT_OPTIONS ] ; then
  options="${USB_MOUNT_OPTIONS}"
fi

if [ ! -e /mnt/usbdevice ]; then
  mkdir /mnt/usbdevice
fi

devname=`basename $DEVNAME`
case $ACTION in
  add)
        vol_id $DEVNAME > /tmp/volumeinfo
	. /tmp/volumeinfo
	rm /tmp/volumeinfo

	if [ "$ID_FS_TYPE" == "vfat" ] ; then
	    mkdir /mnt/usbdevice/$devname
	    mount -t vfat -o $sync,$options $DEVNAME /mnt/usbdevice/$devname
	    ls -la /mnt/usbdevice/$devname
        elif [ "$ID_FS_TYPE" == "ntfs" ] ; then
	    mkdir /mnt/usbdevice/$devname
	    mount -t ntfs -o $sync,$options $DEVNAME /mnt/usbdevice/$devname
	    ls -la /mnt/usbdevice/$devname
	elif echo $DEVNAME | grep "/dev/sd.$" > /dev/null ; then
	    echo_log "We don't mount $DEVNAME directly"
	else
	    mkdir /mnt/usbdevice/$devname
	    if check_module supermount ; then
	        mount -t supermount -o fs=auto,dev=$DEVNAME,--,$sync,$options none /mnt/usbdevice/$devname
	    else
	        # Without supermount we'll just see if the FSTYPE is correct
	        mount -t $ID_FS_TYPE -o $sync,$options $DEVNAME /mnt/usbdevice/$devname
	    fi
	    ls -la /mnt/usbdevice/$devname
	fi
  ;;
  remove)
  	if [ -e /mnt/usbdevice/$devname ] ; then
	    umount /mnt/usbdevice/$devname
	    rmdir /mnt/usbdevice/$devname
	fi
  ;;
esac

exit 0
