/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper.cache;

import com.ebay.sdk.ApiContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;

public abstract class BaseDownloader {
    protected ApiContext apiContext;
    protected String FILE_NAME_PATTERN = "{0}_{1}";
    protected String FILE_EXTENSION = "null";
    protected String FILE_PREFIX = "";
    protected String ROOT_DIR;
    protected String lastUpdateTime;

    public BaseDownloader(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    private void init() throws Exception {
        this.ROOT_DIR = new File(".").getCanonicalPath();
        this.lastUpdateTime = this.getLastUpdateTime();
    }

    private String searchFile() throws Exception {
        File dir = new File(this.ROOT_DIR);
        String[] dataFiles = this.getDataFiles(dir);
        return this.foundLatest(dataFiles);
    }

    private String foundLatest(String[] dataFiles) {
        String name = MessageFormat.format(this.FILE_PREFIX + "_" + this.FILE_NAME_PATTERN, this.apiContext.getSite().toString(), this.lastUpdateTime);
        for (int i = 0; i < dataFiles.length; ++i) {
            if (!dataFiles[i].startsWith(name)) continue;
            return dataFiles[i];
        }
        return null;
    }

    private String[] getDataFiles(File dir) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String site = BaseDownloader.this.apiContext.getSite().toString();
                return name.startsWith(BaseDownloader.this.FILE_PREFIX + "_" + site) && name.endsWith(BaseDownloader.this.FILE_EXTENSION);
            }
        };
        String[] files = dir.list(filter);
        return files;
    }

    protected Object getObject() throws Exception {
        this.init();
        String fileName = this.searchFile();
        Object obj = fileName == null ? this.getFromSite() : this.getFromFile(fileName);
        return obj;
    }

    private Object getFromFile(String fileName) throws Exception {
        String path = this.ROOT_DIR + "/" + fileName;
        FileInputStream f_in = new FileInputStream(path);
        ObjectInputStream obj_in = new ObjectInputStream(f_in);
        return obj_in.readObject();
    }

    private Object getFromSite() throws Exception {
        Object obj = this.individualCall();
        this.saveToDisk(obj);
        return obj;
    }

    private void saveToDisk(Object obj) throws Exception {
        String name = MessageFormat.format(this.FILE_PREFIX + "_" + this.FILE_NAME_PATTERN, this.apiContext.getSite().toString(), this.lastUpdateTime);
        String path = this.ROOT_DIR + "/" + name + "." + this.FILE_EXTENSION;
        FileOutputStream f_out = new FileOutputStream(path);
        ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
        obj_out.writeObject(obj);
    }

    protected abstract Object individualCall() throws Exception;

    protected abstract String getLastUpdateTime() throws Exception;
}

