/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper;

import com.ebay.soap.eBLBaseComponents.InternationalShippingServiceOptionsType;
import com.ebay.soap.eBLBaseComponents.ShippingServiceOptionsType;
import com.ebay.soap.eBLBaseComponents.ShippingTypeCodeType;
import javax.swing.tree.DefaultMutableTreeNode;

public class ShippingServiceOptionTreeBuilder {
    static ShippingServiceOptionTreeBuilder _builder = new ShippingServiceOptionTreeBuilder();

    private ShippingServiceOptionTreeBuilder() {
    }

    public static ShippingServiceOptionTreeBuilder getInstance() {
        return _builder;
    }

    public DefaultMutableTreeNode buildShippingServiceOptionTree(ShippingTypeCodeType shippingType, ShippingServiceOptionsType[] ssos) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("ShippingServiceOptions");
        int size = ssos != null ? ssos.length : 0;
        for (int i = 0; i < size; ++i) {
            ShippingServiceOptionsType sso = ssos[i];
            if (sso.getShippingService() == null) continue;
            top.add(this.buildShippingServiceOptionNode(shippingType, sso));
        }
        return top;
    }

    public DefaultMutableTreeNode buildShippingServiceOptionNode(ShippingTypeCodeType shippingType, ShippingServiceOptionsType sso) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode("ShippingServiceOption");
        parent.add(new DefaultMutableTreeNode("ShippingServicePriority:" + sso.getShippingServicePriority().toString()));
        parent.add(new DefaultMutableTreeNode("ShippingService:" + sso.getShippingService().toString()));
        if (shippingType == ShippingTypeCodeType.FLAT) {
            parent.add(new DefaultMutableTreeNode("ShippingServiceCost:" + sso.getShippingServiceCost().getValue()));
            if (sso.getShippingServiceAdditionalCost() != null) {
                parent.add(new DefaultMutableTreeNode("ShippingServiceAdditionalCost:" + sso.getShippingServiceAdditionalCost().getValue()));
            }
        }
        return parent;
    }

    public DefaultMutableTreeNode buildShippingServiceOptionTree(ShippingTypeCodeType shippingType, InternationalShippingServiceOptionsType[] ssos) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("InternationalShippingServiceOptions");
        int size = ssos != null ? ssos.length : 0;
        for (int i = 0; i < size; ++i) {
            InternationalShippingServiceOptionsType sso = ssos[i];
            if (sso.getShippingService() == null) continue;
            top.add(this.buildShippingServiceOptionNode(shippingType, sso));
        }
        return top;
    }

    public DefaultMutableTreeNode buildShippingServiceOptionNode(ShippingTypeCodeType shippingType, InternationalShippingServiceOptionsType sso) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode("InternationalShippingServiceOptions");
        parent.add(new DefaultMutableTreeNode("ShippingServicePriority:" + sso.getShippingServicePriority().toString()));
        parent.add(new DefaultMutableTreeNode("ShippingService:" + sso.getShippingService().toString()));
        if (shippingType == ShippingTypeCodeType.FLAT) {
            parent.add(new DefaultMutableTreeNode("ShippingServiceCost:" + sso.getShippingServiceCost().getValue()));
            if (sso.getShippingServiceAdditionalCost() != null) {
                parent.add(new DefaultMutableTreeNode("ShippingServiceAdditionalCost:" + sso.getShippingServiceAdditionalCost().getValue()));
            }
        }
        if (sso.getImportCharge() != null) {
            parent.add(new DefaultMutableTreeNode("ImportCharge:" + sso.getImportCharge().getValue()));
        }
        return parent;
    }
}

