/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.call.GetCategoryFeaturesCall;
import com.ebay.soap.eBLBaseComponents.CategoryFeatureType;
import com.ebay.soap.eBLBaseComponents.CategoryType;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import com.ebay.soap.eBLBaseComponents.FeatureDefinitionsType;
import com.ebay.soap.eBLBaseComponents.FeatureIDCodeType;
import com.ebay.soap.eBLBaseComponents.SiteCodeType;
import com.ebay.soap.eBLBaseComponents.SiteDefaultsType;
import java.util.HashMap;

public class GetCategoryFeaturesHelper {
    private ApiContext _apiContext;
    private SiteCodeType _site;
    private String _categoryID = null;
    private Integer _levelLimit = new Integer(3);
    private Boolean _viewAllNodes = new Boolean(true);
    private FeatureIDCodeType[] _featureIDs = null;
    private static HashMap _categoryFeaturesBySite = new HashMap(5);
    private CategoryFeatureType[] _categoryFeatures;
    private static HashMap _categoryVersionsBySite = new HashMap(5);
    private String _categoryVersion;
    private static HashMap _siteDefaultsBySite = new HashMap(5);
    private SiteDefaultsType _siteDefaults;
    private static HashMap _siteFeaturesBySite = new HashMap(5);
    private FeatureDefinitionsType _siteFeatures;

    public GetCategoryFeaturesHelper(ApiContext apiContext) throws SdkException, Exception {
        this._apiContext = apiContext;
        this._site = this._apiContext.getSite();
        this.loadCategoryFeatures(this._site);
    }

    public GetCategoryFeaturesHelper(ApiContext apiContext, String categoryId, Integer levelLimit, Boolean viewAllModes, FeatureIDCodeType[] featureIDs) throws SdkException, Exception {
        this._apiContext = apiContext;
        this._site = this._apiContext.getSite();
        this._categoryID = categoryId;
        this._levelLimit = levelLimit;
        this._viewAllNodes = viewAllModes;
        this._featureIDs = featureIDs;
        this.loadCategoryFeatures(this._site);
    }

    public boolean hasCategoryFeatures(SiteCodeType site) {
        return _categoryFeaturesBySite.containsKey(site) || _categoryVersionsBySite.containsKey(site) || _siteDefaultsBySite.containsKey(site) || _siteFeaturesBySite.containsKey(site);
    }

    public synchronized void loadCategoryFeatures(SiteCodeType site) throws SdkException, Exception {
        if (!_categoryFeaturesBySite.containsKey(site)) {
            SiteCodeType savedSite = this._site;
            this._site = site;
            this.getCategoryFeatures();
            this.addToCategoryFeaturesMap();
            this.addToSiteDefaultsMap();
            this.addToSiteFeaturesMap();
            this.addToCategoryVersionMap();
            this._site = savedSite;
        }
    }

    public void loadCategoryFeatures(ApiContext apiContext) throws SdkException, Exception {
        this._apiContext = apiContext;
        this._site = this._apiContext.getSite();
        this.loadCategoryFeatures(this._site);
    }

    public String getCategoryVersion(SiteCodeType site) {
        return (String)_categoryVersionsBySite.get(site);
    }

    public String getCategoryVersion() {
        return this.getCategoryVersion(this._apiContext.getSite());
    }

    public SiteDefaultsType getSiteDefaults(SiteCodeType site) {
        return (SiteDefaultsType)_siteDefaultsBySite.get(site);
    }

    public SiteDefaultsType getSiteDefaults() {
        return this.getSiteDefaults(this._apiContext.getSite());
    }

    public FeatureDefinitionsType getSiteFeatures(SiteCodeType site) {
        return (FeatureDefinitionsType)_siteFeaturesBySite.get(site);
    }

    public FeatureDefinitionsType getSiteFeatures() {
        return this.getSiteFeatures(this._apiContext.getSite());
    }

    public CategoryFeatureType getCategoryFeature(SiteCodeType site, CategoryType category) {
        HashMap myCategoryMap = (HashMap)_categoryFeaturesBySite.get(site);
        if (myCategoryMap != null) {
            return (CategoryFeatureType)myCategoryMap.get(category);
        }
        return null;
    }

    public CategoryFeatureType getCategoryFeature(CategoryType category) {
        return this.getCategoryFeature(this._apiContext.getSite(), category);
    }

    public SiteCodeType getCurrentSite() {
        return this._site;
    }

    private void addToCategoryFeaturesMap() {
        if (!_categoryFeaturesBySite.containsKey(this._site)) {
            HashMap<String, CategoryFeatureType> myCategoryMap = new HashMap<String, CategoryFeatureType>();
            for (int i = 0; i < this._categoryFeatures.length; ++i) {
                CategoryFeatureType myCategory = this._categoryFeatures[i];
                myCategoryMap.put(myCategory.getCategoryID(), myCategory);
            }
            _categoryFeaturesBySite.put(this._site, myCategoryMap);
        }
    }

    private void addToSiteDefaultsMap() {
        if (!_siteDefaultsBySite.containsKey(this._site)) {
            _siteDefaultsBySite.put(this._site, this._siteDefaults);
        }
    }

    private void addToSiteFeaturesMap() {
        if (!_siteFeaturesBySite.containsKey(this._site)) {
            _siteFeaturesBySite.put(this._site, this._siteFeatures);
        }
    }

    private void addToCategoryVersionMap() {
        if (!_categoryVersionsBySite.containsKey(this._site)) {
            _categoryVersionsBySite.put(this._site, this._categoryVersion);
        }
    }

    private void getCategoryFeatures() throws SdkException, Exception {
        GetCategoryFeaturesCall api = new GetCategoryFeaturesCall(this._apiContext);
        DetailLevelCodeType[] detailLevels = new DetailLevelCodeType[]{DetailLevelCodeType.RETURN_ALL};
        api.setDetailLevel(detailLevels);
        api.setCategoryID(this._categoryID);
        api.setLevelLimit(this._levelLimit);
        api.setViewAllNodes(this._viewAllNodes);
        api.setFeatureIDs(this._featureIDs);
        api.getCategoryFeatures();
        this._categoryFeatures = api.getReturnedCategory();
        this._categoryVersion = api.getReturnedCategoryVersion();
        this._siteDefaults = api.getReturnedSiteDefaults();
        this._siteFeatures = api.getReturnedFeatureDefinitions();
    }
}

