/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.SiteIDUtil;
import com.ebay.sdk.call.CategoryEventListener;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.CategoryType;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import com.ebay.soap.eBLBaseComponents.GetCategoriesRequestType;
import com.ebay.soap.eBLBaseComponents.GetCategoriesResponseType;
import com.ebay.soap.eBLBaseComponents.SiteCodeType;
import java.util.Calendar;

public class GetCategoriesCall
extends ApiCall {
    private SiteCodeType categorySiteID = SiteCodeType.US;
    private String[] parentCategories = null;
    private int levelLimit = 0;
    private Boolean viewAllNodes = null;
    private CategoryType[] returnedCategoryArray = null;
    private Integer returnedCategoryCount = null;
    private Calendar returnedCategoryUpdateTime = null;
    private String returnedCategoryVersion = null;
    private Boolean returnedReservePriceAllowed = null;
    private Double minimumReservePrice = null;
    private Boolean returnedReduceReserveAllowed = null;
    private GetCategoriesResponseType response;

    public GetCategoriesCall() {
    }

    public GetCategoriesCall(ApiContext apiContext) {
        super(apiContext);
    }

    public CategoryType[] getCategories() throws ApiException, SdkException, Exception {
        GetCategoriesResponseType resp;
        GetCategoriesRequestType req = new GetCategoriesRequestType();
        req.setDetailLevel(this.getDetailLevel());
        if (this.categorySiteID != null) {
            req.setCategorySiteID(GetCategoriesCall.stringFromSiteCodeType(this.categorySiteID));
        }
        if (this.parentCategories != null) {
            req.setCategoryParent(this.parentCategories);
        }
        if (this.levelLimit != 0) {
            req.setLevelLimit(new Integer(this.levelLimit));
        }
        if (this.viewAllNodes != null) {
            req.setViewAllNodes(this.viewAllNodes);
        }
        this.returnedCategoryArray = (resp = (GetCategoriesResponseType)this.execute((AbstractRequestType)req)).getCategoryArray() == null ? null : resp.getCategoryArray().getCategory();
        this.returnedCategoryCount = resp.getCategoryCount();
        this.returnedCategoryUpdateTime = resp.getUpdateTime();
        this.returnedCategoryVersion = resp.getCategoryVersion();
        this.returnedReservePriceAllowed = resp.isReservePriceAllowed();
        this.minimumReservePrice = resp.getMinimumReservePrice();
        this.returnedReduceReserveAllowed = resp.isReduceReserveAllowed();
        this.response = resp;
        return this.getReturnedCategoryArray();
    }

    public SiteCodeType getCategorySiteID() {
        return this.categorySiteID;
    }

    public void setCategorySiteID(SiteCodeType categorySiteID) {
        this.categorySiteID = categorySiteID;
    }

    public int getLevelLimit() {
        return this.levelLimit;
    }

    public void setLevelLimit(int levelLimit) {
        this.levelLimit = levelLimit;
    }

    public String[] getParentCategories() {
        return this.parentCategories;
    }

    public void setParentCategories(String[] parentCategories) {
        this.parentCategories = parentCategories;
    }

    public Boolean getViewAllNodes() {
        return this.viewAllNodes;
    }

    public void setViewAllNodes(Boolean viewAllNodes) {
        this.viewAllNodes = viewAllNodes;
    }

    public static int getAllCategories(ApiContext apiContext, SiteCodeType siteID, int levelLimit, DetailLevelCodeType detailLevel, int groupSize, CategoryEventListener listener) throws Exception {
        GetCategoriesCall api = new GetCategoriesCall(apiContext);
        api.setSite(siteID);
        api.setDetailLevel(new DetailLevelCodeType[]{detailLevel});
        api.setLevelLimit(levelLimit);
        api.setCategorySiteID(siteID);
        api.setViewAllNodes(true);
        CategoryType[] rootCats = api.getCategories();
        int tail = rootCats.length - 1;
        int length = 0;
        length = 0;
        while (length <= tail) {
            if (!(rootCats[length].getCategoryLevel() != levelLimit || rootCats[length].isLeafCategory() != null && rootCats[length].isLeafCategory().booleanValue())) {
                ++length;
                continue;
            }
            CategoryType temp = rootCats[length];
            rootCats[length] = rootCats[tail];
            rootCats[tail] = temp;
            --tail;
        }
        int topLength = rootCats.length - length;
        CategoryType[] topCategories = new CategoryType[topLength];
        for (int i = length; i < rootCats.length; ++i) {
            topCategories[i - length] = rootCats[length];
        }
        listener.receivedCategories(siteID, topCategories, api.returnedCategoryVersion);
        int totalDownloaded = topLength;
        int fromId = 0;
        while (fromId < length) {
            api = new GetCategoriesCall(apiContext);
            api.setSite(siteID);
            api.setDetailLevel(new DetailLevelCodeType[]{detailLevel});
            api.setViewAllNodes(true);
            api.setCategorySiteID(siteID);
            int toId = fromId + groupSize - 1;
            if (toId >= length) {
                toId = length - 1;
            }
            int num = toId - fromId + 1;
            String[] parentIdList = new String[num];
            for (int n = 0; n < num; ++n) {
                parentIdList[n] = rootCats[fromId + n].getCategoryID();
            }
            api.setParentCategory(parentIdList);
            CategoryType[] cats = api.getCategories();
            if (cats != null && cats.length > 0) {
                totalDownloaded += cats.length;
                listener.receivedCategories(siteID, cats, api.returnedCategoryVersion);
            }
            if (toId >= rootCats.length - 1) break;
            fromId = toId + 1;
        }
        return totalDownloaded;
    }

    public GetCategoriesResponseType getResponse() {
        return this.response;
    }

    public void setMinimumReservePrice(Double minimumReservePrice) {
        this.minimumReservePrice = minimumReservePrice;
    }

    public void setParentCategory(String[] parentCategories) {
        this.parentCategories = parentCategories;
    }

    public static String stringFromSiteCodeType(SiteCodeType categorySiteID) {
        return new Integer(SiteIDUtil.toNumericalID((SiteCodeType)categorySiteID)).toString();
    }

    public Double getMinimumReservePrice() {
        return this.minimumReservePrice;
    }

    public CategoryType[] getReturnedCategoryArray() {
        return this.returnedCategoryArray;
    }

    public Integer getReturnedCategoryCount() {
        return this.returnedCategoryCount;
    }

    public Calendar getReturnedCategoryUpdateTime() {
        return this.returnedCategoryUpdateTime;
    }

    public String getReturnedCategoryVersion() {
        return this.returnedCategoryVersion;
    }

    public Boolean getReturnedReduceReserveAllowed() {
        return this.returnedReduceReserveAllowed;
    }

    public Boolean getReturnedReservePriceAllowed() {
        return this.returnedReservePriceAllowed;
    }
}

