/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.OnlineStatusListener;
import java.io.IOException;
import java.util.Vector;

public class Script
extends Plugin
implements FilterPlugin {
    private static final int debug = 0;
    private Vector savedScript;
    protected FilterPlugin source;
    private int matchPos;
    private Vector script;
    private byte[] match;
    private boolean done = true;

    public Script(PluginBus bus, final String id) {
        super(bus, id);
        bus.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                Script.this.setup(Script.this.savedScript);
            }

            public void offline() {
            }
        });
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig config) {
                Script.this.savedScript = new Vector();
                String s = config.getProperty("Script", id, "script");
                if (s != null) {
                    if (s.charAt(0) == '@') {
                        Script.this.error("@file not implemented yet");
                    }
                    String[] pair = null;
                    int old = -1;
                    int idx = s.indexOf(124);
                    while (idx >= 0) {
                        if (pair == null) {
                            pair = new String[2];
                            pair[0] = s.substring(old + 1, idx);
                        } else {
                            pair[1] = s.substring(old + 1, idx) + "\n";
                            Script.this.savedScript.addElement(pair);
                            pair = null;
                        }
                        old = idx;
                        idx = s.indexOf(124, old + 1);
                    }
                    if (pair != null) {
                        pair[1] = s.substring(old + 1) + "\n";
                        Script.this.savedScript.addElement(pair);
                    } else {
                        Script.this.error("unmatched pairs of script elements");
                    }
                }
            }
        });
    }

    public void setFilterSource(FilterPlugin plugin) {
        this.source = plugin;
    }

    public int read(byte[] b) throws IOException {
        int n = this.source.read(b);
        if (n > 0) {
            this.match(b, n);
        }
        return n;
    }

    public void write(byte[] b) throws IOException {
        this.source.write(b);
    }

    private void setup(Vector script) {
        this.script = (Vector)script.clone();
        this.match = ((String[])this.script.firstElement())[0].getBytes();
        if (this.match.length == 0) {
            try {
                this.write(this.found());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.reset();
        this.done = false;
    }

    private void match(byte[] s, int length) throws IOException {
        int i = 0;
        while (!this.done && i < length) {
            if (s[i] == this.match[this.matchPos]) {
                if (++this.matchPos >= this.match.length) {
                    this.write(this.found());
                }
            } else {
                this.reset();
            }
            ++i;
        }
    }

    private byte[] found() {
        byte[] answer = ((String[])this.script.firstElement())[1].getBytes();
        this.script.removeElementAt(0);
        if (!this.script.isEmpty()) {
            this.match = ((String[])this.script.firstElement())[0].getBytes();
            this.reset();
        } else {
            this.done = true;
        }
        return answer;
    }

    private void reset() {
        this.matchPos = 0;
    }
}

