/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;

public class GenericUtils {
    public static Class<?> getGenericClass(Class<?> c) {
        ParameterizedType type = null;
        while (c != Object.class) {
            Type genericSuperclass = c.getGenericSuperclass();
            if (!(genericSuperclass instanceof ParameterizedType)) {
                c = c.getSuperclass();
                continue;
            }
            type = (ParameterizedType)genericSuperclass;
            break;
        }
        if (type == null) {
            throw new IllegalArgumentException(c.toString() + " must be parameterized!");
        }
        Type[] actualTypeArguments = type.getActualTypeArguments();
        return actualTypeArguments.length > 0 ? GenericUtils.getClass(actualTypeArguments[0]) : null;
    }

    public static Class<?> getClass(Type type) {
        Type componentType;
        Class<?> componentClass;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return GenericUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType && (componentClass = GenericUtils.getClass(componentType = ((GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(componentClass, 0).getClass();
        }
        return null;
    }

    public static boolean declaresInterface(Class<?> clazz, Class<?> interfce) {
        for (Class<?> i : clazz.getInterfaces()) {
            if (i != interfce) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getTypeArgument(Class<?> clazz, Class<?> interfce) {
        HashMap resolvedTypes = new HashMap();
        Type type = clazz;
        while (!GenericUtils.declaresInterface(GenericUtils.getClass(type), interfce)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            type = rawType.getGenericSuperclass();
        }
        Type actualTypeArgument = type instanceof Class ? type.getTypeParameters()[0] : ((ParameterizedType)type).getActualTypeArguments()[0];
        Class<?> typeArgumentAsClass = null;
        while (resolvedTypes.containsKey(actualTypeArgument)) {
            actualTypeArgument = (Type)resolvedTypes.get(actualTypeArgument);
        }
        typeArgumentAsClass = GenericUtils.getClass(actualTypeArgument);
        return typeArgumentAsClass;
    }

    public static Class<?> getGenericClass(Type genericSuperclass) {
        if (!(genericSuperclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException(genericSuperclass.toString() + " must be parameterized!");
        }
        ParameterizedType type = (ParameterizedType)genericSuperclass;
        return (Class)type.getActualTypeArguments()[0];
    }

    public static Class<?> getGenericClass(Field field) {
        Type type = field.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            throw new RuntimeException("Unable to evaluate Generic class of " + field);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }
}

