/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import org.minimalj.util.FieldUtils;
import org.minimalj.util.IdUtils;

public class EqualsHelper {
    public static boolean equals(Object from, Object to) {
        if (from == null) {
            return to == null;
        }
        if (to == null) {
            return false;
        }
        try {
            return EqualsHelper._equals(from, to);
        }
        catch (IllegalAccessException | IllegalArgumentException x) {
            throw new RuntimeException(x);
        }
    }

    private static boolean _equals(Object from, Object to) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : from.getClass().getDeclaredFields()) {
            if (FieldUtils.isStatic(field)) continue;
            field.setAccessible(true);
            Object fromValue = field.get(from);
            Object toValue = field.get(to);
            if (fromValue == null && toValue == null) continue;
            if (fromValue == null && toValue != null) {
                return false;
            }
            if (fromValue != null && toValue == null) {
                return false;
            }
            if (fromValue instanceof Collection) {
                Collection fromCollection = (Collection)fromValue;
                Collection toCollection = (Collection)toValue;
                if (fromCollection.size() != toCollection.size()) {
                    return false;
                }
                Iterator toIterator = toCollection.iterator();
                for (Object fromObject : fromCollection) {
                    boolean itemEqual = EqualsHelper._equals(fromObject, toIterator.next());
                    if (itemEqual) continue;
                    return false;
                }
                continue;
            }
            if (!(IdUtils.hasId(fromValue.getClass()) ? !IdUtils.equals(fromValue, toValue) : !fromValue.equals(toValue))) continue;
            return false;
        }
        return true;
    }
}

