/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.minimalj.model.annotation.Size;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;
import org.minimalj.util.LocaleContext;
import org.minimalj.util.StringUtils;

public class DateUtils {
    private static final Map<Locale, DateTimeFormatter> dateFormatByLocale = new HashMap<Locale, DateTimeFormatter>();
    public static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm");
    public static final DateTimeFormatter TIME_FORMAT_WITH_SECONDS = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter TIME_FORMAT_WITH_MILIS = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static SimpleDateFormat xsdDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public static DateTimeFormatter getDateTimeFormatter() {
        Locale locale = LocaleContext.getCurrent();
        if (!dateFormatByLocale.containsKey(locale)) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendLocalized(FormatStyle.MEDIUM, null).toFormatter(locale);
            dateFormatByLocale.put(locale, formatter);
        }
        return dateFormatByLocale.get(locale);
    }

    public static String parseCH(String inputText, boolean partialAllowed) {
        if (StringUtils.isEmpty(inputText)) {
            return null;
        }
        String text = DateUtils.cutNonDigitsAtBegin(inputText);
        if (StringUtils.isEmpty(text)) {
            return "";
        }
        if (StringUtils.isEmpty(text = DateUtils.cutNonDigitsAtEnd(text))) {
            return "";
        }
        if (inputText.indexOf(".") > -1) {
            return DateUtils.parseCHWithDot(inputText, partialAllowed);
        }
        return DateUtils.parseCHWithoutDot(inputText, partialAllowed);
    }

    private static String parseCHWithDot(String text, boolean partialAllowed) {
        TrippleString trippleString = new TrippleString(text);
        if (!(trippleString.s1 == null || trippleString.s1.length() <= 2 || partialAllowed && StringUtils.isBlank(trippleString.s2))) {
            return "";
        }
        if (!(trippleString.s2 == null || trippleString.s2.length() <= 2 || partialAllowed && StringUtils.isBlank(trippleString.s3))) {
            return "";
        }
        if (trippleString.s3 != null && trippleString.s3.length() > 4) {
            return "";
        }
        if (!StringUtils.isBlank(trippleString.s3)) {
            return DateUtils.pad(DateUtils.completeYear(trippleString.s3), 4) + "-" + DateUtils.pad(trippleString.s2, 2) + "-" + DateUtils.pad(trippleString.s1, 2);
        }
        if (!StringUtils.isBlank(trippleString.s2)) {
            if (partialAllowed) {
                return DateUtils.pad(DateUtils.completeYear(trippleString.s2), 4) + "-" + DateUtils.pad(trippleString.s1, 2);
            }
            return "";
        }
        if (!StringUtils.isBlank(trippleString.s1) && trippleString.s1.length() <= 4 && partialAllowed) {
            return DateUtils.pad(DateUtils.completeYear(trippleString.s1), 4);
        }
        return "";
    }

    private static String parseCHWithoutDot(String text, boolean partialAllowed) {
        int length = text.length();
        if (!partialAllowed && length != 6 && length != 8) {
            return "";
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return "";
        }
        if (length == 4) {
            return text;
        }
        if (length == 6) {
            return DateUtils.completeYear(text.substring(4, 6)) + "-" + text.substring(2, 4) + "-" + text.substring(0, 2);
        }
        if (length == 8) {
            return DateUtils.completeYear(text.substring(4, 8)) + "-" + text.substring(2, 4) + "-" + text.substring(0, 2);
        }
        return "";
    }

    private static String cutNonDigitsAtBegin(String text) {
        while (text.length() > 0 && !Character.isDigit(text.charAt(0))) {
            text = text.substring(1);
        }
        return text;
    }

    private static String cutNonDigitsAtEnd(String text) {
        while (text.length() > 0 && !Character.isDigit(text.charAt(text.length() - 1))) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private static String completeYear(String year) {
        if (year.length() == 2 && year.compareTo("20") < 1) {
            year = "20" + year;
        }
        if (year.length() == 2) {
            year = "19" + year;
        }
        return year;
    }

    private static String pad(String s, int length) {
        return StringUtils.padLeft(s, length, '0');
    }

    public static String format(LocalDate date) {
        if (date == null) {
            return null;
        }
        return DateUtils.getDateTimeFormatter().format(date);
    }

    public static LocalDate parse(String date) {
        if (StringUtils.isEmpty(date)) {
            return null;
        }
        if (date.contains(".")) {
            date = DateUtils.parseCH(date, false);
            return LocalDate.parse(date);
        }
        return LocalDate.parse(date, DateUtils.getDateTimeFormatter());
    }

    public static String format(String value) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        if (InvalidValues.isInvalid(value)) {
            return InvalidValues.getInvalidValue(value);
        }
        TrippleString trippleString = new TrippleString(value);
        if (!StringUtils.isEmpty(trippleString.s3)) {
            return trippleString.s3 + "." + trippleString.s2 + "." + trippleString.s1;
        }
        if (!StringUtils.isEmpty(trippleString.s2)) {
            return trippleString.s2 + "." + trippleString.s1;
        }
        return trippleString.s1;
    }

    public static String formatXsd(Date date) {
        String s = xsdDateTimeFormat.format(date);
        StringBuilder sb = new StringBuilder(s);
        sb.insert(22, ':');
        return sb.toString();
    }

    public static Date parseXsd(String xmlDateTime) throws ParseException {
        if (xmlDateTime.length() < 25) {
            throw new ParseException("Date not in expected xml datetime format", 0);
        }
        StringBuilder sb = new StringBuilder(xmlDateTime);
        sb.deleteCharAt(22);
        return xsdDateTimeFormat.parse(sb.toString());
    }

    public static int getTimeSize(PropertyInterface property) {
        Size size = property.getAnnotation(Size.class);
        if (size == null) {
            return 5;
        }
        return size.value();
    }

    public static DateTimeFormatter getTimeFormatter(PropertyInterface property) {
        if (property == null) {
            return TIME_FORMAT;
        }
        Size size = property.getAnnotation(Size.class);
        if (size == null) {
            return TIME_FORMAT;
        }
        if (size.value() == 5) {
            return TIME_FORMAT;
        }
        if (size.value() == 8) {
            return TIME_FORMAT_WITH_SECONDS;
        }
        if (size.value() == 12) {
            return TIME_FORMAT_WITH_MILIS;
        }
        return TIME_FORMAT;
    }

    public static class TrippleString {
        public String s1 = "";
        public String s2;
        public String s3;

        public TrippleString(String text) {
            int index;
            for (index = 0; index < text.length() && Character.isDigit(text.charAt(index)); ++index) {
                this.s1 = this.s1 + text.charAt(index);
            }
            while (index < text.length() && !Character.isDigit(text.charAt(index))) {
                ++index;
            }
            this.s2 = "";
            while (index < text.length() && Character.isDigit(text.charAt(index))) {
                this.s2 = this.s2 + text.charAt(index);
                ++index;
            }
            while (index < text.length() && !Character.isDigit(text.charAt(index))) {
                ++index;
            }
            this.s3 = "";
            while (index < text.length() && Character.isDigit(text.charAt(index))) {
                this.s3 = this.s3 + text.charAt(index);
                ++index;
            }
        }
    }
}

