/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.List;
import org.minimalj.model.properties.FlatProperties;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.CloneHelper;
import org.minimalj.util.FieldUtils;
import org.minimalj.util.StringUtils;

public class CsvReader {
    private static final char SEPARATOR = ',';
    private static final char QUOTE_CHAR = '\"';
    private final PushbackReader reader;

    public CsvReader(InputStream is) {
        this.reader = new PushbackReader(new InputStreamReader(is));
    }

    public <T> List<T> readValues(Class<T> clazz) {
        List<String> fields = this.readRecord();
        ArrayList<PropertyInterface> properties = new ArrayList<PropertyInterface>(fields.size());
        for (String field : fields) {
            try {
                field = field.trim();
                if (StringUtils.isEmpty(field)) {
                    throw new RuntimeException("csv - file contains empty header field");
                }
                properties.add(FlatProperties.getProperty(clazz, field));
            }
            catch (IllegalArgumentException x) {
                throw new RuntimeException("No field " + field + " in " + clazz.getSimpleName() + ". Please check csv - file for missing or invalid header line");
            }
        }
        ArrayList<T> objects = new ArrayList<T>();
        List<String> values = this.readRecord();
        while (values != null) {
            T object = CloneHelper.newInstance(clazz);
            for (int i = 0; i < fields.size(); ++i) {
                String stringValue = values.get(i);
                PropertyInterface property = (PropertyInterface)properties.get(i);
                Object value = FieldUtils.parse(stringValue.trim(), property.getClazz());
                property.setValue(object, value);
            }
            objects.add(object);
            values = this.readRecord();
        }
        return objects;
    }

    public List<String> readRecord() {
        try {
            return this._readRecord();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    private List<String> _readRecord() throws IOException {
        int c;
        do {
            if ((c = this.reader.read()) >= 0) continue;
            return null;
        } while (Character.isWhitespace(c));
        this.reader.unread(c);
        ArrayList<String> values = new ArrayList<String>();
        String value = this.readField();
        values.add(value);
        while (value != null) {
            int c2 = this.reader.read();
            if (c2 == 44) {
                value = this.readField();
                values.add(value);
                continue;
            }
            if (c2 >= 0 && c2 != 10) continue;
            value = null;
        }
        return values;
    }

    String readField() throws IOException {
        int c;
        block3: {
            do {
                if ((c = this.reader.read()) == -1) {
                    return "";
                }
                if (!Character.isWhitespace(c)) break block3;
            } while (c != 10);
            this.reader.unread(c);
            return "";
        }
        this.reader.unread(c);
        if (c == 34) {
            return this.readEscaped();
        }
        return this.readNonEscaped();
    }

    String readEscaped() throws IOException {
        StringBuilder s = new StringBuilder();
        int quote = this.reader.read();
        if (quote != 34) {
            throw new IllegalStateException();
        }
        while (true) {
            int c;
            if ((c = this.reader.read()) == -1) {
                throw new IllegalStateException("Non closing quote");
            }
            if (c == 34) {
                int c2 = this.reader.read();
                if (c2 == 34) {
                    s.append((char)c);
                    continue;
                }
                this.reader.unread(c2);
                return s.toString();
            }
            s.append((char)c);
        }
    }

    String readNonEscaped() throws IOException {
        StringBuilder s = new StringBuilder();
        int c;
        while ((c = this.reader.read()) >= 0) {
            if (c == 44 || c == 10) {
                this.reader.unread(c);
                return s.toString().trim();
            }
            s.append((char)c);
        }
        return s.toString().trim();
    }
}

