/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.lang.reflect.Field;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.minimalj.backend.Backend;
import org.minimalj.model.Code;
import org.minimalj.model.Keys;
import org.minimalj.model.Rendering;
import org.minimalj.repository.query.By;
import org.minimalj.util.FieldUtils;
import org.minimalj.util.IdUtils;
import org.minimalj.util.LocaleContext;

public class Codes {
    private static HashMap<Class<?>, CodeCacheItem<?>> cache = new HashMap();

    public static <T extends Code> T findCode(Class<T> clazz, String codeId) {
        return Codes.findCode(clazz, (Object)codeId);
    }

    public static <T extends Code> T findCode(Class<T> clazz, Integer codeId) {
        return Codes.findCode(clazz, (Object)codeId);
    }

    public static <T extends Code> T findCode(Class<T> clazz, Object codeId) {
        List<T> codes = Codes.get(clazz);
        return Codes.findCode(codes, codeId);
    }

    public static <T extends Code> T findCode(List<T> codes, Object codeId) {
        for (Code code : codes) {
            Object aCodeId = IdUtils.getId(code);
            if ((aCodeId != null || codeId != null) && !aCodeId.equals(codeId)) continue;
            return (T)code;
        }
        return null;
    }

    public static boolean isCode(Class<?> clazz) {
        return Code.class.isAssignableFrom(clazz);
    }

    public static synchronized <T extends Code> List<T> get(Class<T> clazz) {
        CodeCacheItem<?> cacheItem = cache.get(clazz);
        if (cacheItem == null || !cacheItem.isValid()) {
            Codes.updateCode(clazz);
        }
        cacheItem = cache.get(clazz);
        List<?> codes = cacheItem.getCodes(LocaleContext.getCurrent());
        return codes;
    }

    private static <T extends Code> void updateCode(Class<T> clazz) {
        CodeCacheItem<T> codeItem = new CodeCacheItem<T>();
        cache.put(clazz, codeItem);
        List<T> codes = Backend.find(clazz, By.all());
        codeItem.setCodes(codes);
    }

    public static <T extends Code> List<T> getConstants(Class<T> clazz) {
        ArrayList<Code> constants = new ArrayList<Code>();
        for (Field field : clazz.getDeclaredFields()) {
            Code constant;
            if (!FieldUtils.isStatic(field) || !FieldUtils.isFinal(field) || field.getType() != clazz || Keys.isKeyObject(constant = (Code)FieldUtils.getStaticValue(field))) continue;
            constants.add(constant);
        }
        return constants;
    }

    public static class CodeCacheItem<S extends Code> {
        private final long timestamp = System.currentTimeMillis();
        private List<S> codes;
        private Map<Locale, List<S>> codesSortedByLocale;

        public boolean isValid() {
            return (System.currentTimeMillis() - this.timestamp) / 1000L < 10L;
        }

        public List<S> getCodes() {
            return this.codes;
        }

        public List<S> getCodes(Locale locale) {
            if (this.codes != null) {
                if (!this.codesSortedByLocale.containsKey(locale)) {
                    ArrayList<S> sortedCodes = new ArrayList<S>(this.codes);
                    Collections.sort(sortedCodes, new CodeComparator(locale));
                    this.codesSortedByLocale.put(locale, sortedCodes);
                }
                return this.codesSortedByLocale.get(locale);
            }
            return null;
        }

        public boolean isLoading() {
            return this.codes == null;
        }

        public void setCodes(List<S> codes) {
            this.codes = codes;
            this.codesSortedByLocale = new HashMap<Locale, List<S>>();
        }
    }

    private static class CodeComparator
    implements Comparator<Code> {
        private final Collator collator = Collator.getInstance(LocaleContext.getCurrent());

        public CodeComparator(Locale locale) {
        }

        @Override
        public int compare(Code o1, Code o2) {
            String string1 = Rendering.render(o1, Rendering.RenderType.PLAIN_TEXT);
            String string2 = Rendering.render(o2, Rendering.RenderType.PLAIN_TEXT);
            return this.collator.compare(string1, string2);
        }
    }
}

