/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.minimalj.repository.list.RelationList;
import org.minimalj.util.FieldUtils;

public class CloneHelper {
    private static Map<Class<?>, Constructor<?>> contructors = new HashMap(200);

    public static <T> T clone(T object) {
        if (object == null) {
            return null;
        }
        return CloneHelper.clone(object, new ArrayList(), new ArrayList());
    }

    public static <T> T clone(T object, List originals, List copies) {
        int pos = originals.indexOf(object);
        if (pos >= 0) {
            return (T)copies.get(pos);
        }
        Class<?> clazz = object.getClass();
        try {
            Object copy = CloneHelper.newInstance(clazz);
            originals.add(object);
            copies.add(copy);
            CloneHelper._deepCopy(object, copy, originals, copies);
            return (T)copy;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deepCopy(Object from, Object to) {
        if (from == null) {
            throw new IllegalArgumentException("from must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("to must not be null");
        }
        if (from.getClass() != to.getClass()) {
            throw new IllegalArgumentException("from and to must have exactly same class, from has " + from.getClass() + " to has " + to.getClass());
        }
        try {
            CloneHelper._deepCopy(from, to, new ArrayList(), new ArrayList());
        }
        catch (IllegalAccessException | IllegalArgumentException x) {
            throw new RuntimeException(x);
        }
    }

    private static void _deepCopy(Object from, Object to, List originals, List copies) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : from.getClass().getDeclaredFields()) {
            if (FieldUtils.isStatic(field)) continue;
            Object fromValue = field.get(from);
            Object toValue = field.get(to);
            if (fromValue instanceof List) {
                List fromList = (List)fromValue;
                ArrayList toList = (ArrayList)toValue;
                if (fromList instanceof RelationList) {
                    field.set(to, fromList);
                    continue;
                }
                if (fromList == null) continue;
                if (FieldUtils.isFinal(field)) {
                    toList.clear();
                } else {
                    toList = new ArrayList();
                    field.set(to, toList);
                }
                for (Object element : fromList) {
                    toList.add(CloneHelper.clone(element, originals, copies));
                }
                continue;
            }
            if (fromValue instanceof Set) {
                Set fromSet = (Set)field.get(from);
                Set toSet = (Set)toValue;
                toSet.clear();
                toSet.addAll(fromSet);
                continue;
            }
            if (CloneHelper.isPrimitive(field)) {
                if (FieldUtils.isFinal(field)) continue;
                field.set(to, fromValue);
                continue;
            }
            if (FieldUtils.isFinal(field)) {
                if (fromValue == null) continue;
                if (toValue != null) {
                    CloneHelper._deepCopy(fromValue, toValue, originals, copies);
                    continue;
                }
                throw new IllegalStateException("final field is not null in from object but null in to object. Field: " + field);
            }
            if (FieldUtils.isTransient(field) || fromValue == null) {
                field.set(to, fromValue);
                continue;
            }
            if (fromValue instanceof byte[]) {
                toValue = ((byte[])fromValue).clone();
                field.set(to, toValue);
                continue;
            }
            toValue = CloneHelper.clone(fromValue, originals, copies);
            field.set(to, toValue);
        }
    }

    private static boolean isPrimitive(Field field) {
        String fieldTypeName = field.getType().getName();
        if (field.getType().isPrimitive() || fieldTypeName.startsWith("java")) {
            return true;
        }
        return Enum.class.isAssignableFrom(field.getType());
    }

    public static <T> T newInstance(Class<T> clazz) {
        Constructor<Object> constructor = contructors.get(clazz);
        if (constructor == null) {
            try {
                constructor = clazz.getConstructor(new Class[0]);
                contructors.put(clazz, constructor);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Object newInstance = constructor.newInstance(new Object[0]);
            return (T)newInstance;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

