/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.security.model;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.minimalj.model.Keys;
import org.minimalj.model.annotation.Size;

public class Password
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Password $ = Keys.of(Password.class);
    public static final String HASH_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int HASH_ITERATIONS = 1000;
    public static final int HASH_SIZE = 24;
    public static final int SALT_SIZE = 24;
    @Size(value=24)
    public byte[] hash;
    @Size(value=24)
    public byte[] salt;

    public void setPassword(char[] password) {
        this.salt = new byte[24];
        SecureRandom random = new SecureRandom();
        random.nextBytes(this.salt);
        this.hash = this.hash(password, this.salt);
    }

    public boolean validatePassword(char[] password) {
        byte[] hashToValidate = this.hash(password, this.salt);
        SecureRandom random = new SecureRandom();
        try {
            Thread.sleep(random.nextInt(100));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Password cannot be validated", e);
        }
        return Arrays.equals(hashToValidate, this.hash);
    }

    private byte[] hash(char[] password, byte[] salt) {
        PBEKeySpec keySpec = new PBEKeySpec(password, salt, 1000, 192);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(HASH_ALGORITHM);
            return secretKeyFactory.generateSecret(keySpec).getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException("Hashing not possible", e);
        }
    }
}

