/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.security;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.minimalj.application.Application;
import org.minimalj.backend.Backend;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.editor.Editor;
import org.minimalj.frontend.form.Form;
import org.minimalj.frontend.form.element.PasswordFormElement;
import org.minimalj.security.Authentication;
import org.minimalj.security.Subject;
import org.minimalj.security.model.User;
import org.minimalj.security.model.UserPassword;
import org.minimalj.transaction.Transaction;

public abstract class UserPasswordAuthentication
extends Authentication {
    private static final long serialVersionUID = 1L;

    @Override
    public void login(Authentication.LoginListener loginListener) {
        new UserPasswordAction(loginListener).action();
    }

    protected User retrieveUser(String userName, char[] password) {
        User user = this.retrieveUser(userName);
        if (user != null && user.password.validatePassword(password)) {
            return user;
        }
        return null;
    }

    protected abstract User retrieveUser(String var1);

    public static class LoginTransaction
    implements Transaction<Subject> {
        private static final long serialVersionUID = 1L;
        private final UserPassword userPassword;

        public LoginTransaction(UserPassword userPassword) {
            Objects.nonNull(userPassword);
            Objects.nonNull(userPassword.user);
            this.userPassword = userPassword;
        }

        public UserPassword getLogin() {
            return this.userPassword;
        }

        @Override
        public Subject execute() {
            User user = ((UserPasswordAuthentication)Backend.getInstance().getAuthentication()).retrieveUser(this.userPassword.user, this.userPassword.password);
            if (user == null) {
                return null;
            }
            Subject subject = Backend.getInstance().getAuthentication().createSubject(this.userPassword.user);
            List roleNames = user.roles.stream().map(role -> role.name).collect(Collectors.toList());
            subject.getRoles().addAll(roleNames);
            return subject;
        }
    }

    public static class UserPasswordAction
    extends Editor<UserPassword, Subject> {
        private final Authentication.LoginListener listener;

        public UserPasswordAction(Authentication.LoginListener listener) {
            this.listener = listener;
        }

        @Override
        protected UserPassword createObject() {
            return new UserPassword();
        }

        @Override
        protected Form<UserPassword> createForm() {
            Form<UserPassword> form = new Form<UserPassword>();
            form.line((Object)UserPassword.$.user);
            form.line((Object)new PasswordFormElement(UserPassword.$.password));
            return form;
        }

        @Override
        protected List<Action> createAdditionalActions() {
            if (!Application.getInstance().isLoginRequired()) {
                AnonymousLoginAction action = new AnonymousLoginAction();
                return Collections.singletonList(action);
            }
            return Collections.emptyList();
        }

        @Override
        protected Subject save(UserPassword userPassword) {
            LoginTransaction loginTransaction = new LoginTransaction(userPassword);
            return Backend.execute(loginTransaction);
        }

        @Override
        protected boolean closeWith(Subject subject) {
            if (subject != null) {
                return true;
            }
            Frontend.showError("Login failed");
            return false;
        }

        @Override
        public void cancel() {
            this.listener.loginCancelled();
            super.cancel();
        }

        @Override
        protected void finished(Subject subject) {
            this.listener.loginSucceded(subject);
        }

        private class AnonymousLoginAction
        extends Action {
            private AnonymousLoginAction() {
            }

            @Override
            public void action() {
                UserPasswordAction.this.listener.loginSucceded(null);
                UserPasswordAction.super.cancel();
            }
        }
    }
}

