/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.annotation.AnnotationUtil;
import org.minimalj.model.properties.Properties;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;
import org.minimalj.repository.sql.SqlIdentifier;
import org.minimalj.util.DateUtils;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.IdUtils;

public abstract class SqlDialect {
    public static final Logger sqlLogger = Logger.getLogger("SQL");
    private final Set<String> foreignKeyNames = new HashSet<String>();
    private final Set<String> indexNames = new HashSet<String>();

    public abstract int getMaxIdentifierLength();

    protected void addCreateStatementBegin(StringBuilder s, String tableName) {
        s.append("CREATE TABLE ").append(tableName).append(" (\n");
    }

    protected void addIdColumn(StringBuilder s, PropertyInterface idProperty) {
        Class<?> fieldClazz = idProperty.getClazz();
        int size = fieldClazz == String.class ? AnnotationUtil.getSize(idProperty) : 0;
        this.addIdColumn(s, fieldClazz, size);
    }

    protected void addIdColumn(StringBuilder s, Class<?> idClass, int size) {
        s.append(" id ");
        if (idClass == Integer.class) {
            s.append("INT");
        } else if (idClass == String.class) {
            s.append("VARCHAR(");
            s.append(size);
            s.append(')');
        } else if (idClass == Object.class) {
            s.append("CHAR(36)");
        } else {
            throw new IllegalArgumentException();
        }
        s.append(" NOT NULL");
    }

    public void addColumnDefinition(StringBuilder s, PropertyInterface property) {
        Class<?> clazz = property.getClazz();
        if (clazz == Integer.class) {
            s.append("INTEGER");
        } else if (clazz == Long.class) {
            s.append("BIGINT");
        } else if (clazz == String.class) {
            s.append("VARCHAR");
            int size = AnnotationUtil.getSize(property);
            s.append(" (").append(size).append(')');
        } else if (clazz == LocalDate.class) {
            s.append("DATE");
        } else if (clazz == LocalTime.class) {
            s.append("TIME");
        } else if (clazz == LocalDateTime.class) {
            s.append("DATETIME");
        } else if (clazz == BigDecimal.class) {
            s.append("DECIMAL");
            int size = AnnotationUtil.getSize(property);
            int decimal = AnnotationUtil.getDecimal(property);
            if (decimal == 0) {
                s.append(" (").append(size).append(')');
            } else {
                s.append(" (").append(size).append(", ").append(decimal).append(')');
            }
        } else if (clazz == Boolean.class) {
            s.append("BIT");
        } else if (Enum.class.isAssignableFrom(clazz)) {
            s.append("INTEGER");
        } else if (clazz == Set.class) {
            s.append("INTEGER");
        } else if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
            s.append("BLOB");
            int size = AnnotationUtil.getSize(property, true);
            if (size > 0) {
                s.append(" (").append(size).append(')');
            }
        } else if (IdUtils.hasId(clazz)) {
            PropertyInterface idProperty = Properties.getProperty(clazz, "id");
            this.addColumnDefinition(s, idProperty);
        } else {
            s.append("CHAR(36)");
        }
    }

    protected void addPrimaryKey(StringBuilder s, String keys) {
        s.append(",\n PRIMARY KEY (");
        s.append(keys);
        s.append(')');
    }

    protected void addCreateStatementEnd(StringBuilder s) {
        s.append("\n)");
    }

    public String createConstraint(String tableName, String column, String referencedTableName, boolean referencedTableIsHistorized) {
        String name = "FK_" + tableName + "_" + column;
        name = SqlIdentifier.buildIdentifier(name, this.getMaxIdentifierLength(), this.foreignKeyNames);
        this.foreignKeyNames.add(name);
        StringBuilder s = new StringBuilder();
        s.append("ALTER TABLE ").append(tableName);
        s.append(" ADD CONSTRAINT ");
        s.append(name);
        s.append(" FOREIGN KEY (");
        s.append(column);
        s.append(") REFERENCES ");
        s.append(referencedTableName);
        s.append(" (ID)");
        return s.toString();
    }

    public String createIndex(String tableName, String column, boolean withVersion) {
        String name = "IDX_" + tableName + "_" + column;
        name = SqlIdentifier.buildIdentifier(name, this.getMaxIdentifierLength(), this.indexNames);
        this.indexNames.add(name);
        StringBuilder s = new StringBuilder();
        s.append("CREATE INDEX ");
        s.append(name);
        s.append(" ON ");
        s.append(tableName);
        s.append('(');
        s.append(column);
        if (withVersion) {
            s.append(", version");
        }
        s.append(')');
        return s.toString();
    }

    public String createUniqueIndex(String tableName, String column) {
        StringBuilder s = new StringBuilder();
        s.append("ALTER TABLE ");
        s.append(tableName);
        s.append(" ADD UNIQUE INDEX ");
        s.append(column);
        s.append(" (");
        s.append(column);
        s.append(')');
        return s.toString();
    }

    public String limit(int rows, Integer offset) {
        return "OFFSET " + (offset != null ? offset.toString() : Integer.valueOf(0)) + " ROWS FETCH NEXT " + rows + " ROWS ONLY";
    }

    public void setParameter(PreparedStatement preparedStatement, int param, Object value, PropertyInterface property) throws SQLException {
        if (value == null || InvalidValues.isInvalid(value)) {
            this.setParameterNull(preparedStatement, param, property);
        } else {
            if (value instanceof Enum) {
                Enum e = (Enum)value;
                value = e.ordinal();
            } else if (value instanceof LocalDate) {
                value = Date.valueOf((LocalDate)value);
            } else if (value instanceof LocalTime) {
                value = Time.valueOf((LocalTime)value);
            } else if (value instanceof LocalDateTime) {
                value = Timestamp.valueOf((LocalDateTime)value);
            } else if (value instanceof Set) {
                Set set = (Set)value;
                Class<?> enumClass = GenericUtils.getGenericClass(property.getType());
                value = EnumUtils.getInt(set, enumClass);
            } else if (value instanceof UUID) {
                value = value.toString();
            }
            preparedStatement.setObject(param, value);
        }
    }

    public void setParameterNull(PreparedStatement preparedStatement, int param, PropertyInterface property) throws SQLException {
        Class<?> clazz = property.getClazz();
        if (clazz == String.class) {
            preparedStatement.setNull(param, 12);
        } else if (clazz == UUID.class) {
            preparedStatement.setNull(param, 1);
        } else if (clazz == Integer.class) {
            preparedStatement.setNull(param, 4);
        } else if (clazz == Boolean.class) {
            preparedStatement.setNull(param, 4);
        } else if (clazz == BigDecimal.class || clazz == Long.class) {
            preparedStatement.setNull(param, 3);
        } else if (Enum.class.isAssignableFrom(clazz)) {
            preparedStatement.setNull(param, 4);
        } else if (clazz == LocalDate.class) {
            preparedStatement.setNull(param, 91);
        } else if (clazz == LocalTime.class) {
            preparedStatement.setNull(param, 92);
        } else if (clazz == LocalDateTime.class) {
            preparedStatement.setNull(param, 91);
        } else if (IdUtils.hasId(clazz)) {
            preparedStatement.setNull(param, 4);
        } else if (property.getClazz().isArray()) {
            preparedStatement.setNull(param, 2004);
        } else {
            preparedStatement.setNull(param, 4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object convertToFieldClass(Class<?> fieldClass, Object value) {
        if (value == null) {
            return null;
        }
        if (fieldClass == LocalDate.class) {
            if (value instanceof Date) {
                return ((Date)value).toLocalDate();
            }
            if (value instanceof Timestamp) {
                return ((Timestamp)value).toLocalDateTime().toLocalDate();
            }
            if (!(value instanceof String)) throw new IllegalArgumentException(value.getClass().getSimpleName());
            return LocalDate.parse((String)value);
        }
        if (fieldClass == LocalTime.class) {
            if (value instanceof Time) {
                return ((Time)value).toLocalTime();
            }
            if (value instanceof Timestamp) {
                return ((Timestamp)value).toLocalDateTime().toLocalTime();
            }
            if (!(value instanceof String)) throw new IllegalArgumentException(value.getClass().getSimpleName());
            return LocalTime.parse((String)value);
        }
        if (fieldClass == LocalDateTime.class) {
            if (value instanceof Timestamp) {
                return ((Timestamp)value).toLocalDateTime();
            }
            if (value instanceof Date) {
                return ((Date)value).toLocalDate().atStartOfDay();
            }
            if (value instanceof Timestamp) {
                return ((Timestamp)value).toLocalDateTime();
            }
            if (!(value instanceof String)) throw new IllegalArgumentException(value.getClass().getSimpleName());
            return LocalDateTime.parse((String)value);
        }
        if (fieldClass == Boolean.class) {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof Integer) {
                return (Integer)value == 1;
            }
            if (value == null) return value;
            throw new IllegalArgumentException(value.getClass().getSimpleName());
        }
        if (Enum.class.isAssignableFrom(fieldClass)) {
            return EnumUtils.valueList(fieldClass).get((Integer)value);
        }
        if (fieldClass != UUID.class) return value;
        return UUID.fromString((String)value);
    }

    public static class OracleSqlDialect
    extends SqlDialect {
        @Override
        public void setParameter(PreparedStatement preparedStatement, int param, Object value, PropertyInterface property) throws SQLException {
            if (value instanceof Temporal && !InvalidValues.isInvalid(value)) {
                value = value.toString();
            }
            super.setParameter(preparedStatement, param, value, property);
        }

        @Override
        public void setParameterNull(PreparedStatement preparedStatement, int param, PropertyInterface property) throws SQLException {
            Class<?> clazz = property.getClazz();
            if (clazz == LocalTime.class || clazz == LocalDate.class || clazz == LocalDateTime.class) {
                preparedStatement.setNull(param, 1);
            } else {
                super.setParameterNull(preparedStatement, param, property);
            }
        }

        @Override
        public void addColumnDefinition(StringBuilder s, PropertyInterface property) {
            Class<?> clazz = property.getClazz();
            if (clazz == LocalDateTime.class) {
                s.append("TIMESTAMP");
            } else if (clazz == LocalDate.class) {
                s.append("CHAR(10)");
            } else if (clazz == LocalTime.class) {
                s.append("CHAR(").append(DateUtils.getTimeSize(property)).append(")");
            } else if (clazz == LocalTime.class) {
                s.append("CHAR(30)");
            } else if (clazz == LocalDate.class) {
                s.append("DATE");
            } else if (clazz == Boolean.class) {
                s.append("SMALLINT");
            } else if (clazz == Long.class) {
                s.append("LONG");
            } else {
                super.addColumnDefinition(s, property);
            }
        }

        @Override
        public String createConstraint(String tableName, String column, String referencedTableName, boolean referencedTableIsHistorized) {
            if (!referencedTableIsHistorized) {
                return super.createConstraint(tableName, column, referencedTableName, referencedTableIsHistorized);
            }
            return null;
        }

        @Override
        public String createUniqueIndex(String tableName, String column) {
            StringBuilder s = new StringBuilder();
            s.append("ALTER TABLE ");
            s.append(tableName);
            s.append(" ADD CONSTRAINT ");
            s.append(column);
            s.append("_UNIQUE UNIQUE (");
            s.append(column);
            s.append(')');
            return s.toString();
        }

        @Override
        public int getMaxIdentifierLength() {
            return 30;
        }
    }

    public static class DerbySqlDialect
    extends SqlDialect {
        @Override
        public void addColumnDefinition(StringBuilder s, PropertyInterface property) {
            Class<?> clazz = property.getClazz();
            if (clazz == LocalDateTime.class) {
                s.append("TIMESTAMP");
            } else if (clazz == Boolean.class) {
                s.append("SMALLINT");
            } else {
                super.addColumnDefinition(s, property);
            }
        }

        @Override
        public String createConstraint(String tableName, String column, String referencedTableName, boolean referencedTableIsHistorized) {
            if (!referencedTableIsHistorized) {
                return super.createConstraint(tableName, column, referencedTableName, referencedTableIsHistorized);
            }
            return null;
        }

        @Override
        public String createUniqueIndex(String tableName, String column) {
            StringBuilder s = new StringBuilder();
            s.append("ALTER TABLE ");
            s.append(tableName);
            s.append(" ADD CONSTRAINT ");
            s.append(column);
            s.append("_UNIQUE UNIQUE (");
            s.append(column);
            s.append(')');
            return s.toString();
        }

        @Override
        public int getMaxIdentifierLength() {
            return 128;
        }
    }

    public static class H2SqlDialect
    extends SqlDialect {
        @Override
        public String createConstraint(String tableName, String column, String referencedTableName, boolean referencedTableIsHistorized) {
            if (!referencedTableIsHistorized) {
                return super.createConstraint(tableName, column, referencedTableName, referencedTableIsHistorized);
            }
            return null;
        }

        @Override
        public int getMaxIdentifierLength() {
            return 256;
        }
    }

    public static class MariaSqlDialect
    extends SqlDialect {
        @Override
        protected void addCreateStatementEnd(StringBuilder s) {
            s.append("\n) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED\n");
        }

        @Override
        public void addColumnDefinition(StringBuilder s, PropertyInterface property) {
            Class<?> clazz = property.getClazz();
            if (clazz.isArray() && clazz.getComponentType() == Byte.TYPE) {
                int size = AnnotationUtil.getSize(property, true);
                if (size < 0) {
                    s.append("LONGBLOB");
                } else if (size < 256) {
                    s.append("TINYBLOB");
                } else if (size < 65536) {
                    s.append("BLOB");
                } else if (size < 0xFFFFFF) {
                    s.append("MEDIUMBLOB");
                } else {
                    s.append("LONGBLOB");
                }
            } else {
                super.addColumnDefinition(s, property);
            }
        }

        @Override
        public int getMaxIdentifierLength() {
            return 64;
        }

        @Override
        public String limit(int rows, Integer offset) {
            return "LIMIT " + rows + (offset != null ? " OFFSET " + offset.toString() : "");
        }
    }
}

