/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.repository.sql.AbstractTable;
import org.minimalj.repository.sql.SqlDialect;
import org.minimalj.repository.sql.SqlRepository;
import org.minimalj.repository.sql.SubTable;
import org.minimalj.util.EqualsHelper;
import org.minimalj.util.IdUtils;

public class HistorizedSubTable<PARENT, ELEMENT>
extends SubTable<PARENT, ELEMENT> {
    protected final String selectByIdAndTimeQuery = this.selectByIdAndTimeQuery();
    private final String endQuery = this.endQuery();

    public HistorizedSubTable(SqlRepository sqlRepository, String prefix, Class<ELEMENT> clazz, PropertyInterface parentIdProperty) {
        super(sqlRepository, prefix, clazz, parentIdProperty);
    }

    @Override
    public void addList(PARENT parent, List<ELEMENT> objects) {
        int version = 0;
        try (PreparedStatement insertStatement = HistorizedSubTable.createStatement(this.sqlRepository.getConnection(), this.insertQuery, false);){
            for (int position = 0; position < objects.size(); ++position) {
                ELEMENT object = objects.get(position);
                int parameterPos = this.setParameters(insertStatement, object, false, AbstractTable.ParameterMode.INSERT, IdUtils.getId(parent));
                insertStatement.setInt(parameterPos++, position);
                insertStatement.setInt(parameterPos++, version);
                insertStatement.execute();
            }
        }
        catch (SQLException x) {
            throw new RuntimeException(x.getMessage());
        }
    }

    public void replaceAll(PARENT parent, List<ELEMENT> objects, int version) {
        int oldVersion = version - 1;
        List<ELEMENT> objectsInDb = this.read(parent, oldVersion);
        Object parentId = IdUtils.getId(parent);
        for (int position = 0; position < Math.max(objects.size(), objectsInDb.size()); ++position) {
            Throwable throwable;
            boolean end = false;
            boolean insert = false;
            if (position < objectsInDb.size() && position < objects.size()) {
                ELEMENT objectInDb;
                ELEMENT object = objects.get(position);
                insert = !EqualsHelper.equals(object, objectInDb = objectsInDb.get(position));
                end = insert;
            } else if (position < objectsInDb.size()) {
                end = true;
            } else {
                insert = true;
            }
            if (end) {
                try {
                    throwable = null;
                    try (PreparedStatement endStatement = HistorizedSubTable.createStatement(this.sqlRepository.getConnection(), this.endQuery, false);){
                        endStatement.setInt(1, version);
                        endStatement.setObject(2, parentId);
                        endStatement.setInt(3, position);
                        endStatement.execute();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (SQLException x) {
                    throw new RuntimeException(x.getMessage());
                }
            }
            if (!insert) continue;
            try {
                throwable = null;
                try (PreparedStatement insertStatement = HistorizedSubTable.createStatement(this.sqlRepository.getConnection(), this.insertQuery, false);){
                    int parameterPos = this.setParameters(insertStatement, objects.get(position), false, AbstractTable.ParameterMode.HISTORIZE, parentId);
                    insertStatement.setInt(parameterPos++, position);
                    insertStatement.setInt(parameterPos++, version);
                    insertStatement.execute();
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (SQLException x) {
                throw new RuntimeException(x.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ELEMENT> read(PARENT parent, Integer time) {
        if (time == null) {
            return this.getList(parent);
        }
        try (PreparedStatement selectByIdAndTimeStatement = HistorizedSubTable.createStatement(this.sqlRepository.getConnection(), this.selectByIdAndTimeQuery, false);){
            selectByIdAndTimeStatement.setObject(1, IdUtils.getId(parent));
            selectByIdAndTimeStatement.setInt(2, time);
            selectByIdAndTimeStatement.setInt(3, time);
            List list = this.executeSelectAll(selectByIdAndTimeStatement);
            return list;
        }
        catch (SQLException x) {
            throw new RuntimeException(x.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ELEMENT> getList(PARENT parent) {
        try (PreparedStatement selectByIdStatement = HistorizedSubTable.createStatement(this.sqlRepository.getConnection(), this.selectByIdQuery, false);){
            selectByIdStatement.setObject(1, IdUtils.getId(parent));
            List list = this.executeSelectAll(selectByIdStatement);
            return list;
        }
        catch (SQLException x) {
            throw new RuntimeException(x.getMessage());
        }
    }

    protected String selectByIdAndTimeQuery() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(this.getTableName());
        query.append(" WHERE id = ? AND startVersion <= ? AND endVersion > ? ORDER BY position");
        return query.toString();
    }

    @Override
    protected String selectByIdQuery() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(this.getTableName()).append(" WHERE id = ? AND endVersion = 2147483647 ORDER BY position");
        return query.toString();
    }

    @Override
    protected String insertQuery() {
        StringBuilder s = new StringBuilder();
        s.append("INSERT INTO ").append(this.getTableName()).append(" (");
        Iterator<String> iterator = this.getColumns().keySet().iterator();
        while (iterator.hasNext()) {
            String columnNameObject;
            String columnName = columnNameObject = iterator.next();
            s.append(columnName).append(", ");
        }
        s.append("id, position, startVersion, endVersion) VALUES (");
        for (int i = 0; i < this.getColumns().keySet().size(); ++i) {
            s.append("?, ");
        }
        s.append("?, ?, ?, 2147483647)");
        return s.toString();
    }

    private String endQuery() {
        StringBuilder s = new StringBuilder();
        s.append("UPDATE ").append(this.getTableName()).append(" SET endVersion = ? WHERE id = ? AND position = ? AND endVersion = 2147483647");
        return s.toString();
    }

    @Override
    protected void addSpecialColumns(SqlDialect dialect, StringBuilder s) {
        s.append(" id ");
        dialect.addColumnDefinition(s, this.parentIdProperty);
        s.append(",\n startVersion INTEGER NOT NULL");
        s.append(",\n endVersion INTEGER NOT NULL");
        s.append(",\n position INTEGER NOT NULL");
    }

    @Override
    protected void addPrimaryKey(SqlDialect dialect, StringBuilder s) {
        dialect.addPrimaryKey(s, "id, startVersion, position");
    }
}

