/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository.query;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import org.minimalj.model.Keys;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.repository.query.Criteria;
import org.minimalj.repository.query.FieldOperator;

public class FieldCriteria
extends Criteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FieldOperator operator;
    private final Object value;
    private transient PropertyInterface property;
    private final String path;

    public FieldCriteria(Object key, Object value) {
        this(key, FieldOperator.equal, value);
    }

    public FieldCriteria(Object key, FieldOperator operator, Object value) {
        this.operator = operator;
        this.value = value;
        this.property = Keys.getProperty(key);
        this.assertValidOperator(this.property, operator);
        this.assertValidValueClass(this.property, value);
        this.path = this.property.getPath();
    }

    private FieldCriteria(String path, FieldOperator operator, Object value) {
        this.path = path;
        this.operator = operator;
        this.value = value;
    }

    private void assertValidOperator(PropertyInterface property, FieldOperator operator) {
        Class<?> clazz = property.getClazz();
        if (clazz == Integer.class || clazz == Long.class || clazz == BigDecimal.class || Temporal.class.isAssignableFrom(clazz)) {
            return;
        }
        if (operator == FieldOperator.equal) {
            return;
        }
        throw new IllegalArgumentException((Object)((Object)operator) + " only allowed for Integer, Long and BigDecimal fields");
    }

    private void assertValidValueClass(PropertyInterface property, Object value) {
        if (value != null && !property.getClazz().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Value is " + value.getClass().getName() + " but must be " + property.getClazz().getSimpleName());
        }
    }

    public FieldOperator getOperator() {
        return this.operator;
    }

    public String getPath() {
        return this.path;
    }

    public PropertyInterface getProperty() {
        return this.property;
    }

    public Object getValue() {
        return this.value;
    }

    public Criteria negate() {
        return new FieldCriteria(this.path, this.operator.negate(), this.value);
    }
}

