/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.repository;

import java.sql.SQLException;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.mariadb.jdbc.MariaDbDataSource;
import org.minimalj.util.LoggingRuntimeException;

public class DataSourceFactory {
    public static final Logger logger = Logger.getLogger(DataSourceFactory.class.getName());
    private static int memoryDbCount = 1;

    public static DataSource getJndiDataSource() {
        try {
            InitialContext initContext = new InitialContext();
            DataSource dataSource = (DataSource)initContext.lookup("java:/comp/env/jdbc");
            return dataSource;
        }
        catch (NamingException e) {
            logger.fine("Exception while retrieving JNDI datasource (" + e.getMessage() + ")");
            return null;
        }
    }

    public static DataSource embeddedDataSource() {
        return DataSourceFactory.embeddedDataSource(null);
    }

    public static DataSource embeddedDataSource(String file) {
        JdbcDataSource dataSource;
        try {
            dataSource = new JdbcDataSource();
        }
        catch (NoClassDefFoundError e) {
            logger.severe("Missing JdbcDataSource. Please ensure to have h2 in the classpath");
            throw new IllegalStateException("Configuration error: Missing JdbcDataSource");
        }
        dataSource.setUrl(file != null ? "jdbc:h2:" + file : "jdbc:h2:mem:TempDB" + memoryDbCount++);
        return dataSource;
    }

    public static DataSource embeddedDerbyDataSource(String file) {
        EmbeddedDataSource dataSource;
        try {
            dataSource = new EmbeddedDataSource();
        }
        catch (NoClassDefFoundError e) {
            logger.severe("Missing EmbeddedDataSource. Please ensure to have derby in the classpath");
            throw new IllegalStateException("Configuration error: Missing EmbeddedDataSource");
        }
        dataSource.setDatabaseName(file != null ? file : "memory:TempDB" + memoryDbCount++);
        dataSource.setCreateDatabase("create");
        return dataSource;
    }

    public static DataSource dataSource(String url, String user, String password) {
        if (url.startsWith("jdbc:oracle")) {
            return DataSourceFactory.oracleDbDataSource(url, user, password);
        }
        if (url.startsWith("jdbc:mariadb")) {
            return DataSourceFactory.mariaDbDataSource(url, user, password);
        }
        throw new RuntimeException("Unknown jdbc URL: " + url);
    }

    public static DataSource mariaDbDataSource(String url, String user, String password) {
        try {
            MariaDbDataSource dataSource = new MariaDbDataSource();
            dataSource.setUrl(url);
            dataSource.setUser(user);
            dataSource.setPassword(password);
            return dataSource;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (NoClassDefFoundError e) {
            logger.severe("Missing MariaDbDataSource. Please ensure to have mariadb-java-client in the classpath");
            throw new IllegalStateException("Configuration error: Missing MariaDbDataSource");
        }
    }

    public static DataSource oracleDbDataSource(String url, String user, String password) {
        try {
            Class<?> dataSourceClass = Class.forName("oracle.jdbc.pool.OracleDataSource");
            DataSource dataSource = (DataSource)dataSourceClass.newInstance();
            dataSourceClass.getMethod("setURL", String.class).invoke((Object)dataSource, url);
            dataSourceClass.getMethod("setUser", String.class).invoke((Object)dataSource, user);
            dataSourceClass.getMethod("setPassword", String.class).invoke((Object)dataSource, password);
            return dataSource;
        }
        catch (Exception e) {
            throw new LoggingRuntimeException(e, logger, "Cannot connect to oracle db");
        }
    }
}

