/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.model.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.minimalj.application.Application;
import org.minimalj.application.DevMode;
import org.minimalj.model.CodeItem;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.View;
import org.minimalj.model.annotation.AnnotationUtil;
import org.minimalj.model.annotation.TechnicalField;
import org.minimalj.model.properties.FlatProperties;
import org.minimalj.model.properties.Properties;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.Codes;
import org.minimalj.util.FieldUtils;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.IdUtils;
import org.minimalj.util.StringUtils;
import org.minimalj.util.resources.Resources;

public class ModelTest {
    private static final Logger logger = Logger.getLogger(ModelTest.class.getName());
    private final Collection<Class<?>> mainClasses;
    private Set<Class<?>> modelClasses = new HashSet();
    private final List<String> problems = new ArrayList<String>();

    public ModelTest(Class<?> ... modelClasses) {
        this(Arrays.asList(modelClasses));
    }

    public ModelTest(Collection<Class<?>> mainClasses) {
        this.mainClasses = mainClasses;
        for (Class<?> clazz : mainClasses) {
            this.testClass(clazz);
        }
        if (DevMode.isActive()) {
            Resources.printMissing();
        }
    }

    public static void exitIfProblems() {
        ModelTest test = new ModelTest(Application.getInstance().getEntityClasses());
        if (!test.getProblems().isEmpty()) {
            test.logProblems();
            System.exit(-1);
        }
    }

    public List<String> getProblems() {
        return this.problems;
    }

    public void assertValid() {
        if (!this.getProblems().isEmpty()) {
            this.logProblems();
            throw new IllegalArgumentException("The persistent classes don't apply to the given rules");
        }
    }

    public Set<Class<?>> getModelClasses() {
        return Collections.unmodifiableSet(this.modelClasses);
    }

    public void logProblems() {
        if (!this.problems.isEmpty()) {
            logger.severe("The entitiy classes don't apply to the given rules");
            for (String s : this.problems) {
                logger.severe(s);
            }
        }
    }

    public boolean isValid() {
        return this.problems.isEmpty();
    }

    private void testClass(Class<?> clazz) {
        if (!this.modelClasses.contains(clazz)) {
            this.modelClasses.add(clazz);
            this.testName(clazz);
            this.testNoSuperclass(clazz);
            if (!this.testNoSelfMixins(clazz)) {
                return;
            }
            this.testId(clazz);
            this.testVersion(clazz);
            this.testHistorized(clazz);
            this.testConstructor(clazz);
            this.testFields(clazz);
            this.testSelfReferences(clazz);
            if (!IdUtils.hasId(clazz)) {
                this.testNoListFields(clazz);
            }
            if (DevMode.isActive()) {
                this.testResources(clazz);
            }
        }
    }

    private void testInlineClass(Class<?> clazz) {
        this.testName(clazz);
        this.testNoSuperclass(clazz);
        this.testFields(clazz);
    }

    private void testConstructor(Class<?> clazz) {
        if (Enum.class.isAssignableFrom(clazz)) {
            try {
                EnumUtils.createEnum(clazz, "Test");
            }
            catch (Exception e) {
                this.problems.add("Not possible to create runtime instance of enum " + clazz.getName() + ". Possibly there is no empty constructor");
            }
        } else {
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    this.problems.add("Constructor of " + clazz.getName() + " not public");
                }
            }
            catch (NoSuchMethodException e) {
                this.problems.add(clazz.getName() + " has no public empty constructor");
            }
        }
    }

    private boolean isMain(Class<?> clazz) {
        return this.mainClasses.contains(clazz);
    }

    private void testNoSuperclass(Class<?> clazz) {
        if (clazz.getSuperclass() != Object.class && (clazz.getSuperclass() != Enum.class || this.isMain(clazz))) {
            this.problems.add(clazz.getName() + ": Domain classes must not extends other classes");
        }
    }

    private boolean testNoSelfMixins(Class<?> clazz) {
        return this.testNoSelfMixins(clazz, Collections.emptyList());
    }

    private boolean testNoSelfMixins(Class<?> clazz, List<Class<?>> outerClasses) {
        Field[] fields;
        ArrayList forbiddenClasses = new ArrayList(outerClasses);
        forbiddenClasses.add(clazz);
        for (Field field : fields = clazz.getFields()) {
            if (FieldUtils.isTransient(field) || FieldUtils.isStatic(field) || !FieldUtils.isFinal(field) || FieldUtils.isList(field)) continue;
            Class<?> mixinClass = field.getType();
            if (forbiddenClasses.contains(mixinClass)) {
                this.problems.add(clazz.getName() + ": Mixin classes must not mix in itself");
                return false;
            }
            return this.testNoSelfMixins(mixinClass);
        }
        return true;
    }

    private void testId(Class<?> clazz) {
        block7: {
            try {
                PropertyInterface property = FlatProperties.getProperty(clazz, "id");
                if (Codes.isCode(clazz)) {
                    if (!FieldUtils.isAllowedCodeId(property.getClazz())) {
                        this.problems.add(clazz.getName() + ": Code id must be of Integer, String or Object");
                    }
                } else if (property.getClazz() != Object.class) {
                    this.problems.add(clazz.getName() + ": Id must be Object");
                }
            }
            catch (IllegalArgumentException e) {
                if (Codes.isCode(clazz)) {
                    this.problems.add(clazz.getName() + ": Code classes must have an id field of Integer, String or Object");
                }
                if (!this.isMain(clazz)) break block7;
                this.problems.add(clazz.getName() + ": Domain classes must have an id field of type object");
            }
        }
    }

    private void testVersion(Class<?> clazz) {
        try {
            Field fieldVersion = clazz.getField("version");
            if (this.isMain(clazz) && !Codes.isCode(clazz)) {
                if (fieldVersion.getType() == Integer.class) {
                    this.problems.add(clazz.getName() + ": Domain classes version must be of primitiv type int");
                }
                if (!FieldUtils.isPublic(fieldVersion)) {
                    this.problems.add(clazz.getName() + ": field version must be public");
                }
            } else {
                this.problems.add(clazz.getName() + ": Only main entities are allowed to have an version field");
            }
        }
        catch (NoSuchFieldException fieldVersion) {
        }
        catch (SecurityException e) {
            this.problems.add(clazz.getName() + " makes SecurityException with the version field");
        }
    }

    private void testHistorized(Class<?> clazz) {
        try {
            Field fieldVersion = clazz.getField("historized");
            if (this.isMain(clazz) && !Codes.isCode(clazz)) {
                if (fieldVersion.getType() != Boolean.TYPE) {
                    this.problems.add(clazz.getName() + ": Domain classes historized must be of primitiv type boolean");
                }
                if (!FieldUtils.isPublic(fieldVersion)) {
                    this.problems.add(clazz.getName() + ": field version must be public");
                }
            } else {
                this.problems.add(clazz.getName() + ": Only main entities are allowed to have an historized field");
            }
        }
        catch (NoSuchFieldException fieldVersion) {
        }
        catch (SecurityException e) {
            this.problems.add(clazz.getName() + " makes SecurityException with the historized field");
        }
    }

    private void testFields(Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getFields()) {
            this.testField(field);
        }
    }

    private void testField(Field field) {
        if (FieldUtils.isPublic(field) && !FieldUtils.isStatic(field) && !FieldUtils.isTransient(field) && !StringUtils.equals(field.getName(), "id", "version", "historized")) {
            this.testName(field);
            this.testTypeOfField(field);
            this.testNoMethodsForPublicField(field);
            TechnicalField technicalField = field.getAnnotation(TechnicalField.class);
            if (technicalField != null) {
                this.testTypeOfTechnicalField(field, technicalField.value());
            }
            Class<?> fieldType = field.getType();
            if (!View.class.isAssignableFrom(field.getDeclaringClass())) {
                if (fieldType == String.class) {
                    this.testStringSize(field);
                } else if (fieldType == LocalTime.class || fieldType == LocalDateTime.class) {
                    this.testTimeSize(field);
                }
            }
        }
    }

    private void testNoListFields(Class<?> clazz) {
        Field[] fields;
        FlatProperties.getProperties(clazz).values();
        for (Field field : fields = clazz.getFields()) {
            if (!FieldUtils.isPublic(field) || FieldUtils.isStatic(field) || FieldUtils.isTransient(field)) continue;
            Class<?> fieldType = field.getType();
            if (List.class.equals(fieldType)) {
                this.problems.add("List in " + clazz.getName() + ": not allowed. Only classes with id (or inlines of classes with id) may contain lists");
                continue;
            }
            if (!FieldUtils.isFinal(field) || FieldUtils.isAllowedPrimitive(fieldType)) continue;
            this.testNoListFields(fieldType);
        }
    }

    private void testName(Field field) {
        String name = field.getName();
        String messagePrefix = field.getName() + " of " + field.getDeclaringClass().getName();
        this.testName(name, messagePrefix);
    }

    private void testName(Class<?> clazz) {
        String name = clazz.getSimpleName();
        String messagePrefix = "Class " + clazz.getSimpleName();
        this.testName(name, messagePrefix);
    }

    private void testName(String name, String messagePrefix) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (this.isIdentifierChar(c)) continue;
            this.problems.add(messagePrefix + " has an invalid name. " + c + " is not allowed");
            break;
        }
    }

    private boolean isIdentifierChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    private void testTypeOfField(Field field) {
        Class<?> fieldType = field.getType();
        String messagePrefix = field.getName() + " of " + field.getDeclaringClass().getName();
        if (fieldType == List.class) {
            this.testTypeOfListField(field, messagePrefix);
        } else if (fieldType == Set.class) {
            if (!FieldUtils.isFinal(field)) {
                this.problems.add(messagePrefix + " must be final (" + fieldType.getSimpleName() + " Fields must be final)");
            }
            this.testTypeOfSetField(field, messagePrefix);
        } else {
            this.testTypeOfField(field, messagePrefix);
        }
    }

    private void testTypeOfListField(Field field, String messagePrefix) {
        Class<?> listType = null;
        try {
            listType = GenericUtils.getGenericClass(field);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (listType != null) {
            this.testTypeOfListField(listType, "Generic of " + messagePrefix);
            if (IdUtils.hasId(listType) && FieldUtils.isFinal(field)) {
                this.problems.add("List of identifiables must not be final: " + messagePrefix);
            }
        } else {
            this.problems.add("Could not evaluate generic of " + messagePrefix);
        }
    }

    private void testTypeOfSetField(Field field, String messagePrefix) {
        Class<?> setType = null;
        try {
            setType = GenericUtils.getGenericClass(field);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (setType != null) {
            List<CodeItem<?>> values;
            if (!Enum.class.isAssignableFrom(setType)) {
                this.problems.add("Set type must be an enum class: " + messagePrefix);
            }
            if ((values = EnumUtils.itemList(setType)).size() > 32) {
                this.problems.add("Set enum must not have more than 32 elements: " + messagePrefix);
            }
        } else {
            this.problems.add("Could not evaluate generic of " + messagePrefix);
        }
    }

    private void testTypeOfField(Field field, String messagePrefix) {
        Class<?> fieldType = field.getType();
        if (FieldUtils.isAllowedPrimitive(fieldType)) {
            return;
        }
        if (fieldType.isPrimitive()) {
            this.problems.add(messagePrefix + " has invalid Type");
        }
        if (Modifier.isAbstract(fieldType.getModifiers())) {
            this.problems.add(messagePrefix + " must not be of an abstract Type");
        }
        if (fieldType.isArray()) {
            this.problems.add(messagePrefix + " is an array which is not allowed (except for byte[])");
        }
        if (FieldUtils.isFinal(field)) {
            this.testInlineClass(fieldType);
        } else {
            this.testClass(fieldType);
        }
    }

    private void testTypeOfListField(Class<?> fieldType, String messagePrefix) {
        if (fieldType.isPrimitive()) {
            this.problems.add(messagePrefix + " has invalid Type");
            return;
        }
        if (Modifier.isAbstract(fieldType.getModifiers())) {
            this.problems.add(messagePrefix + " must not be of an abstract Type");
            return;
        }
        if (fieldType.isArray()) {
            this.problems.add(messagePrefix + " is an array which is not allowed");
            return;
        }
        if (Codes.isCode(fieldType)) {
            this.problems.add(messagePrefix + " is a list of codes which is not allowed");
            return;
        }
        this.testClass(fieldType);
    }

    private void testStringSize(Field field) {
        PropertyInterface property = Properties.getProperty(field);
        try {
            AnnotationUtil.getSize(property);
        }
        catch (IllegalArgumentException x) {
            this.problems.add("Missing size for: " + property.getDeclaringClass().getName() + "." + property.getPath());
        }
    }

    private void testTimeSize(Field field) {
        PropertyInterface property = Properties.getProperty(field);
        int size = AnnotationUtil.getSize(property, true);
        if (size > -1 && size != 5 && size != 8 && size != 12) {
            this.problems.add("Unsupported size for: " + property.getDeclaringClass().getName() + "." + property.getPath() + " - only Size.TIME_ constants can be used");
        }
    }

    private void testNoMethodsForPublicField(Field field) {
        PropertyInterface property = Properties.getProperty(field);
        if (property != null) {
            if (property.getClass().getSimpleName().startsWith("Method")) {
                this.problems.add("A public attribute must not have getter or setter methods: " + field.getDeclaringClass().getName() + "." + field.getName());
            }
        } else {
            this.problems.add("No property for " + field.getName());
        }
    }

    private void testTypeOfTechnicalField(Field field, TechnicalField.TechnicalFieldType type) {
        if (type == TechnicalField.TechnicalFieldType.CREATE_DATE || type == TechnicalField.TechnicalFieldType.EDIT_DATE) {
            if (field.getType() != LocalDateTime.class) {
                this.problems.add("Technical field " + type.name() + " must be of LocalDateTime, not " + field.getType().getName());
            }
        } else if ((type == TechnicalField.TechnicalFieldType.CREATE_USER || type == TechnicalField.TechnicalFieldType.EDIT_USER) && field.getType() != String.class) {
            this.problems.add("Technical field " + type.name() + " must be of String, not " + field.getType().getName());
        }
    }

    private void testResources(Class<?> clazz) {
        for (PropertyInterface property : FlatProperties.getProperties(clazz).values()) {
            if (StringUtils.equals(property.getName(), "id", "version")) continue;
            Resources.getPropertyName(property);
        }
    }

    private void testSelfReferences(Class<?> clazz) {
        this.testSelfReferences(clazz, new HashSet());
    }

    private void testSelfReferences(Class<?> clazz, Set<Class<?>> forbiddenClasses) {
        Field[] fields;
        for (Field field : fields = clazz.getFields()) {
            Class<?> fieldType;
            if (!FieldUtils.isPublic(field) || FieldUtils.isStatic(field) || FieldUtils.isTransient(field) || FieldUtils.isAllowedPrimitive(fieldType = field.getType()) || fieldType == List.class || fieldType == Set.class || fieldType == Object.class) continue;
            if (forbiddenClasses.contains(fieldType)) {
                this.problems.add("Self reference cycle with: " + fieldType.getSimpleName());
                continue;
            }
            forbiddenClasses.add(fieldType);
            this.testSelfReferences(fieldType, forbiddenClasses);
            forbiddenClasses.remove(fieldType);
        }
    }
}

