/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.model.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.logging.Logger;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.CloneHelper;
import org.minimalj.util.FieldUtils;
import org.minimalj.util.LoggingRuntimeException;

public class FieldProperty
implements PropertyInterface {
    private static Logger logger = Logger.getLogger(FieldProperty.class.getName());
    private final Field field;
    private final boolean isFinal;

    public FieldProperty(Field field) {
        this.field = field;
        this.isFinal = FieldUtils.isFinal(field);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public Object getValue(Object object) {
        try {
            return this.field.get(object);
        }
        catch (Exception e) {
            throw new LoggingRuntimeException(e, logger, "get of " + this.field.getName() + " failed");
        }
    }

    @Override
    public void setValue(Object object, Object value) {
        try {
            if (!this.isFinal) {
                this.field.set(object, value);
            } else {
                Object finalObject = this.field.get(object);
                if (finalObject == value) {
                    return;
                }
                if (finalObject instanceof Collection) {
                    Collection finalCollection = (Collection)finalObject;
                    finalCollection.clear();
                    if (value != null) {
                        finalCollection.addAll((Collection)value);
                    }
                } else {
                    if (value == null) {
                        throw new IllegalArgumentException("Field " + this.field.getName() + " is final and cannot be set to null");
                    }
                    CloneHelper.deepCopy(value, finalObject);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public Type getType() {
        return this.field.getGenericType();
    }

    @Override
    public Class<?> getClazz() {
        return this.field.getType();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }
}

