/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.model.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.minimalj.model.properties.PropertyInterface;

public class ChainedProperty
implements PropertyInterface {
    private final PropertyInterface property1;
    private final PropertyInterface property2;

    public ChainedProperty(PropertyInterface property1, PropertyInterface property2) {
        this.property1 = property1;
        this.property2 = property2;
    }

    public boolean isAvailableFor(Object object) {
        if (this.property1 instanceof ChainedProperty && !((ChainedProperty)this.property1).isAvailableFor(object)) {
            return false;
        }
        return this.property1.getValue(object) != null;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.property2.getDeclaringClass();
    }

    @Override
    public Object getValue(Object object) {
        Object value1 = this.property1.getValue(object);
        if (value1 != null) {
            return this.property2.getValue(value1);
        }
        return null;
    }

    @Override
    public void setValue(Object object, Object value) {
        Object value1 = this.property1.getValue(object);
        if (value1 != null) {
            this.property2.setValue(value1, value);
        }
    }

    @Override
    public String getName() {
        return this.property2.getName();
    }

    @Override
    public String getPath() {
        return this.property1.getPath() + "." + this.property2.getPath();
    }

    @Override
    public Type getType() {
        return this.property2.getType();
    }

    @Override
    public Class<?> getClazz() {
        return this.property2.getClazz();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.property2.getAnnotation(annotationClass);
    }

    @Override
    public boolean isFinal() {
        return this.property2.isFinal();
    }
}

