/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.model;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;
import org.minimalj.util.DateUtils;

public interface Rendering {
    public String render(RenderType var1);

    default public String renderTooltip(RenderType renderType) {
        return null;
    }

    default public RenderType getPreferredRenderType(RenderType firstType, RenderType ... otherTypes) {
        return firstType;
    }

    public static String render(Object o, RenderType renderType) {
        return Rendering.render(o, renderType, null);
    }

    public static String render(Object o, RenderType renderType, PropertyInterface property) {
        if (o instanceof Rendering) {
            return ((Rendering)o).render(renderType);
        }
        if (o instanceof Collection) {
            Collection collection = (Collection)o;
            if (!collection.isEmpty()) {
                StringBuilder s = new StringBuilder();
                for (Object item : collection) {
                    s.append(Rendering.render(item, renderType)).append(", ");
                }
                return s.substring(0, s.length() - 2);
            }
            return "";
        }
        if (o instanceof Enum) {
            Enum enumElement = (Enum)o;
            return EnumUtils.getText(enumElement);
        }
        if (o instanceof LocalDate) {
            return DateUtils.getDateTimeFormatter().format((TemporalAccessor)o);
        }
        if (o instanceof LocalTime) {
            return DateUtils.getTimeFormatter(property).format((LocalTime)o);
        }
        if (o instanceof LocalDateTime) {
            String date = DateUtils.getDateTimeFormatter().format((TemporalAccessor)o);
            String time = DateUtils.getTimeFormatter(property).format((TemporalAccessor)o);
            return date + " " + time;
        }
        if (InvalidValues.isInvalid(o)) {
            return InvalidValues.getInvalidValue(o);
        }
        if (o != null) {
            return o.toString();
        }
        return "";
    }

    public static enum RenderType {
        PLAIN_TEXT,
        HMTL;

    }
}

