/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.page;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.minimalj.backend.Backend;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.editor.Editor;
import org.minimalj.frontend.page.ObjectPage;
import org.minimalj.frontend.page.Page;
import org.minimalj.util.CloneHelper;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.IdUtils;
import org.minimalj.util.resources.Resources;

public abstract class TablePage<T>
extends Page
implements Frontend.TableActionListener<T> {
    private final boolean multiSelect = this.allowMultiselect();
    private final Object[] keys;
    private transient Frontend.ITable<T> table;
    private transient List<T> objects;
    private transient List<TableSelectionAction> actions;
    private transient List<T> selectedObjects;
    private transient boolean reloadFlag;

    public TablePage(Object[] keys) {
        this.keys = keys;
    }

    protected boolean allowMultiselect() {
        return false;
    }

    protected abstract List<T> load();

    @Override
    public String getTitle() {
        String title = Resources.getStringOrNull(this.getClass());
        if (title != null) {
            return title;
        }
        Class<?> tableClazz = GenericUtils.getGenericClass(this.getClass());
        String className = Resources.getString(tableClazz);
        return MessageFormat.format(Resources.getString(TablePage.class.getSimpleName() + ".title"), className);
    }

    @Override
    public Frontend.IContent getContent() {
        this.table = Frontend.getInstance().createTable(this.keys, this.multiSelect, this);
        if (this.objects == null || this.reloadFlag) {
            this.objects = this.load();
            this.reloadFlag = true;
        }
        this.table.setObjects(this.objects);
        this.selectedObjects = null;
        return this.table;
    }

    public void refresh() {
        if (this.table != null) {
            this.objects = this.load();
            this.table.setObjects(this.objects);
            this.reloadFlag = false;
        }
    }

    @Override
    public void selectionChanged(List<T> selectedObjects) {
        this.selectedObjects = selectedObjects;
        if (this.actions != null) {
            this.actions.stream().forEach(action -> action.selectionChanged(selectedObjects));
        }
    }

    public static abstract class SimpleTablePageWithDetail<T>
    extends TablePageWithDetail<T, ObjectPage<T>> {
        public SimpleTablePageWithDetail(Object[] keys) {
            super(keys);
        }

        @Override
        protected ObjectPage<T> updateDetailPage(ObjectPage<T> detailPage, T mainObject) {
            detailPage.setObject(mainObject);
            return detailPage;
        }
    }

    public static abstract class TablePageWithDetail<T, DETAIL_PAGE extends Page>
    extends TablePage<T> {
        private DETAIL_PAGE detailPage;

        public TablePageWithDetail(Object[] keys) {
            super(keys);
        }

        protected abstract DETAIL_PAGE createDetailPage(T var1);

        protected abstract DETAIL_PAGE updateDetailPage(DETAIL_PAGE var1, T var2);

        protected DETAIL_PAGE updateDetailPage(DETAIL_PAGE page, List<T> selectedObjects) {
            if (selectedObjects == null || selectedObjects.size() != 1) {
                return null;
            }
            return this.updateDetailPage(page, selectedObjects.get(0));
        }

        @Override
        public void action(T selectedObject) {
            if (this.detailPage != null) {
                this.updateDetailPage(Collections.singletonList(selectedObject));
            } else {
                this.detailPage = this.createDetailPage(selectedObject);
                if (this.detailPage != null) {
                    Frontend.showDetail(this, this.detailPage);
                }
            }
        }

        @Override
        public void selectionChanged(List<T> selectedObjects) {
            boolean detailVisible;
            super.selectionChanged(selectedObjects);
            boolean bl = detailVisible = this.detailPage != null && Frontend.isDetailShown(this.detailPage);
            if (detailVisible) {
                if (selectedObjects != null && !selectedObjects.isEmpty()) {
                    this.updateDetailPage(selectedObjects);
                } else {
                    Frontend.hideDetail(this.detailPage);
                }
            }
        }

        private void updateDetailPage(List<T> selectedObjects) {
            DETAIL_PAGE updatedDetailPage = this.updateDetailPage(this.detailPage, selectedObjects);
            if (Frontend.isDetailShown(this.detailPage) && (updatedDetailPage == null || updatedDetailPage != this.detailPage)) {
                Frontend.hideDetail(this.detailPage);
            }
            if (updatedDetailPage != null) {
                Frontend.showDetail(this, updatedDetailPage);
                this.detailPage = updatedDetailPage;
            }
        }
    }

    public class DeleteDetailAction
    extends TableSelectionAction {
        public DeleteDetailAction() {
            this.selectionChanged(TablePage.this.selectedObjects);
        }

        @Override
        protected Object[] getNameArguments() {
            Class<?> clazz = GenericUtils.getGenericClass(TablePage.this.getClass());
            if (clazz != null) {
                String resourceName = Resources.getResourceName(clazz);
                return new Object[]{Resources.getString(resourceName)};
            }
            return null;
        }

        @Override
        public void action() {
            for (Object object : TablePage.this.selectedObjects) {
                Backend.delete(object.getClass(), IdUtils.getId(object));
            }
        }

        @Override
        public void selectionChanged(List<T> selectedObjects) {
            this.setEnabled(selectedObjects != null && !selectedObjects.isEmpty());
        }
    }

    public abstract class TableSelectionAction
    extends Action {
        protected TableSelectionAction() {
            if (TablePage.this.actions == null) {
                TablePage.this.actions = new ArrayList();
            }
            TablePage.this.actions.add(this);
        }

        public abstract void selectionChanged(List<T> var1);
    }

    public abstract class NewDetailEditor<DETAIL>
    extends Editor<DETAIL, T> {
        @Override
        protected DETAIL createObject() {
            Class<?> clazz = GenericUtils.getGenericClass(this.getClass());
            Object newInstance = CloneHelper.newInstance(clazz);
            return (DETAIL)newInstance;
        }

        @Override
        protected void finished(T result) {
            TablePage.this.refresh();
            if (TablePage.this instanceof TablePageWithDetail) {
                TablePage.this.action(result);
            }
        }
    }
}

