/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.page;

import org.minimalj.backend.Backend;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.editor.Editor;
import org.minimalj.frontend.form.Form;
import org.minimalj.frontend.page.Page;
import org.minimalj.util.CloneHelper;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.IdUtils;
import org.minimalj.util.resources.Resources;

public abstract class ObjectPage<T>
extends Page {
    private final Class<T> objectClass;
    private Object objectId;
    private transient T object;
    private transient Form<T> form;

    public ObjectPage(T object) {
        this(object.getClass(), IdUtils.getId(object));
    }

    public ObjectPage(Class<T> objectClass, Object objectId) {
        this.objectClass = objectClass;
        this.objectId = objectId;
    }

    public void setObject(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object.getClass() != this.objectClass) {
            throw new IllegalArgumentException("Object is " + object.getClass() + " instead of " + this.objectClass);
        }
        this.objectId = IdUtils.getId(object);
        this.object = object;
        if (this.form != null) {
            this.form.setObject(object);
        }
    }

    @Override
    public String getTitle() {
        String title = Resources.getStringOrNull(this.getClass());
        if (title != null) {
            return title;
        }
        Class<?> clazz = GenericUtils.getGenericClass(this.getClass());
        return Resources.getString(clazz);
    }

    protected abstract Form<T> createForm();

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    public Object getObjectId() {
        return this.objectId;
    }

    public T getObject() {
        if (this.object == null) {
            this.object = this.load();
        }
        return this.object;
    }

    @Override
    public Frontend.IContent getContent() {
        if (this.form == null) {
            this.form = this.createForm();
        }
        this.unload();
        this.form.setObject(this.getObject());
        return this.form.getContent();
    }

    public T load() {
        return Backend.read(this.objectClass, this.objectId);
    }

    public void unload() {
        this.object = null;
    }

    public void refresh() {
        this.setObject(this.load());
    }

    public abstract class ObjectEditor
    extends Editor<T, T> {
        @Override
        protected T createObject() {
            return CloneHelper.clone(ObjectPage.this.getObject());
        }

        @Override
        protected Class<?> getEditedClass() {
            return GenericUtils.getGenericClass(ObjectPage.this.getClass());
        }

        @Override
        protected void finished(T result) {
            ObjectPage.this.setObject(result);
        }
    }
}

