/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.minimalj.frontend.Frontend;
import org.minimalj.util.StringUtils;

public class SwingTextFieldAutocomplete
extends JComboBox<String>
implements Frontend.Input<String>,
PopupMenuListener {
    private static final long serialVersionUID = -1L;
    private final JTextComponent tc;
    private final Frontend.Search<String> suggestionSearch;
    private boolean adjusting = false;

    public SwingTextFieldAutocomplete(final Frontend.InputComponentListener changeListener, Frontend.Search<String> suggestionSearch) {
        super(new SearchListDataModel());
        this.suggestionSearch = suggestionSearch;
        this.setEditable(true);
        Component c = this.getEditor().getEditorComponent();
        if (!(c instanceof JTextComponent)) {
            throw new IllegalStateException("Editing component is not a JTextComponent!");
        }
        this.tc = (JTextComponent)c;
        this.tc.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                changeListener.changed(SwingTextFieldAutocomplete.this);
                if (!SwingTextFieldAutocomplete.this.adjusting) {
                    SwingTextFieldAutocomplete.this.hidePopup();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                changeListener.changed(SwingTextFieldAutocomplete.this);
                if (!SwingTextFieldAutocomplete.this.adjusting) {
                    SwingTextFieldAutocomplete.this.hidePopup();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                changeListener.changed(SwingTextFieldAutocomplete.this);
                if (!SwingTextFieldAutocomplete.this.adjusting) {
                    SwingTextFieldAutocomplete.this.hidePopup();
                }
            }
        });
        this.addPopupMenuListener(this);
    }

    @Override
    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        this.adjusting = true;
        super.configureEditor(anEditor, anItem);
        this.adjusting = false;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.adjusting = true;
        this.updateModel(this.tc);
        this.adjusting = false;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    private void updateModel(JTextComponent tc) {
        SearchListDataModel model = (SearchListDataModel)this.getModel();
        model.setQuery(this.suggestionSearch, tc.getText());
    }

    @Override
    public int getSelectedIndex() {
        if (this.getEditor() == null) {
            return -1;
        }
        String value = this.getValue();
        if (value == null) {
            return -1;
        }
        int index = -1;
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            String item = (String)this.getModel().getElementAt(i);
            if (item == null || !item.startsWith(value)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public void setValue(String text) {
        super.setSelectedItem(text);
    }

    @Override
    public String getValue() {
        Component c = this.getEditor().getEditorComponent();
        JTextComponent tc = (JTextComponent)c;
        return tc.getText();
    }

    private static class SearchListDataModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private static final long serialVersionUID = 1L;
        private String lastSearch;
        private List<String> elements = Collections.emptyList();
        private String selection;

        private SearchListDataModel() {
        }

        public void setQuery(Frontend.Search<String> suggestions, String query) {
            if (!(StringUtils.equals(this.lastSearch, query) || this.selection != null && this.selection.startsWith(query))) {
                this.lastSearch = query;
                this.elements = suggestions.search(query);
                if (this.elements.isEmpty()) {
                    this.elements = Collections.singletonList(query);
                }
                this.selection = this.elements.get(0);
                this.fireContentsChanged(this, 0, this.elements.size());
            }
        }

        @Override
        public int getSize() {
            return this.elements != null ? this.elements.size() : 0;
        }

        @Override
        public String getElementAt(int index) {
            return this.elements.get(index);
        }

        @Override
        public void setSelectedItem(Object selection) {
            this.selection = (String)selection;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selection;
        }
    }
}

