/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;
import org.minimalj.frontend.impl.swing.toolkit.SwingInternalFrame;
import org.minimalj.util.StringUtils;

public class SwingTextField
extends JTextField
implements Frontend.Input<String>,
FocusListener {
    private static final long serialVersionUID = 1L;
    private final Frontend.InputComponentListener changeListener;
    private String textOnFocusLost;

    public SwingTextField(Frontend.InputComponentListener changeListener, int maxLength) {
        this(changeListener, maxLength, null);
    }

    public SwingTextField(Frontend.InputComponentListener changeListener, int maxLength, String allowedCharacters) {
        super(new FilteredDocument(maxLength, allowedCharacters), null, 0);
        this.changeListener = changeListener;
        this.getDocument().addDocumentListener(new TextFieldChangeListener());
        this.setInheritsPopupMenu(true);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action saveAction;
                SwingInternalFrame frame = SwingTextField.this.findFrame();
                if (frame != null && (saveAction = frame.getSaveAction()).isEnabled()) {
                    SwingFrontend.runWithContext(saveAction::action);
                }
            }
        });
        this.addFocusListener(this);
    }

    private SwingInternalFrame findFrame() {
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof SwingInternalFrame)) continue;
            return (SwingInternalFrame)c;
        }
        return null;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.textOnFocusLost != null) {
            super.setText(this.textOnFocusLost);
        }
    }

    @Override
    public void setValue(String value) {
        this.textOnFocusLost = value;
        if (!this.hasFocus() && !StringUtils.equals(value, this.getText())) {
            this.setText(value);
        }
    }

    @Override
    public String getValue() {
        return super.getText();
    }

    static class FilteredDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private final int maxLength;
        private final String allowedCharacters;

        public FilteredDocument(int maxLength, String allowedCharacters) {
            this.maxLength = maxLength;
            this.allowedCharacters = allowedCharacters;
        }

        @Override
        public void insertString(int offset, String additionalString, AttributeSet attr) throws BadLocationException {
            String filteredString;
            int length = this.getLength();
            String actualText = this.getText(0, length);
            String requestedString = actualText.substring(0, offset) + additionalString + actualText.substring(offset, length);
            String filteredAdditionalString = this.filter(additionalString);
            int overLength = actualText.length() + filteredAdditionalString.length() - this.maxLength;
            if (overLength > 0) {
                filteredAdditionalString = filteredAdditionalString.substring(0, filteredAdditionalString.length() - overLength);
            }
            if (requestedString.equals(filteredString = actualText.substring(0, offset) + filteredAdditionalString + actualText.substring(offset, length))) {
                super.insertString(offset, additionalString, attr);
            } else if (!actualText.equals(filteredString)) {
                this.replace(0, length, filteredString, attr);
            }
        }

        private String filter(String s) {
            if (this.allowedCharacters == null) {
                return s;
            }
            String result = "";
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (this.allowedCharacters.indexOf(c) < 0) {
                    if (Character.isLowerCase(c)) {
                        c = Character.toUpperCase(c);
                    } else if (Character.isUpperCase(c)) {
                        c = Character.toLowerCase(c);
                    }
                    if (this.allowedCharacters.indexOf(c) < 0) continue;
                }
                result = result + c;
            }
            return result;
        }
    }

    public class TextFieldChangeListener
    implements DocumentListener,
    Runnable {
        private boolean invokeSet = false;

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.fireChangeEvent();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.fireChangeEvent();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.fireChangeEvent();
        }

        private void fireChangeEvent() {
            if (!this.invokeSet) {
                this.invokeSet = true;
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            this.invokeSet = false;
            SwingTextField.this.textOnFocusLost = null;
            SwingTextField.this.changeListener.changed(SwingTextField.this);
        }
    }
}

