/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.swing.toolkit.SwingTextField;

public class SwingTextAreaField
extends JScrollPane
implements Frontend.Input<String> {
    private static final long serialVersionUID = 1L;
    private final Frontend.InputComponentListener changeListener;
    private final JTextArea textArea;

    public SwingTextAreaField(Frontend.InputComponentListener changeListener, int maxLength, String pattern) {
        this.textArea = new JTextArea(new SwingTextField.FilteredDocument(maxLength, pattern));
        this.textArea.setFont(UIManager.getDefaults().getFont("TextField.font"));
        this.setBorder(UIManager.getDefaults().getBorder("TextField.border"));
        this.textArea.setLineWrap(true);
        this.textArea.setRows(this.calcRows(maxLength));
        this.textArea.getDocument().addDocumentListener(new TextFieldChangeListener());
        this.setViewportView(this.textArea);
        this.changeListener = changeListener;
    }

    private int calcRows(int maxLength) {
        int rows = 1;
        while (maxLength > 1) {
            ++rows;
            maxLength /= 3;
        }
        return rows;
    }

    @Override
    public void setValue(String value) {
        this.textArea.setText(value);
    }

    @Override
    public String getValue() {
        return this.textArea.getText();
    }

    @Override
    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    public class TextFieldChangeListener
    implements DocumentListener {
        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.fireChangeEvent();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.fireChangeEvent();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.fireChangeEvent();
        }

        private void fireChangeEvent() {
            SwingTextAreaField.this.changeListener.changed(SwingTextAreaField.this);
        }
    }
}

