/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.impl.swing.component.EditablePanel;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;
import org.minimalj.frontend.page.IDialog;

public class SwingInternalFrame
extends JInternalFrame
implements IDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(SwingInternalFrame.class.getName());
    private final EditablePanel editablePanel;
    private final Component focusAfterClose;
    private final Action saveAction;
    private final Action closeAction;

    public SwingInternalFrame(EditablePanel editablePanel, String title, Component content, Action saveAction, Action closeAction) {
        this(editablePanel, title, content, saveAction, closeAction, null);
    }

    public SwingInternalFrame(EditablePanel editablePanel, String title, Component content, Action saveAction, Action closeAction, Component focusAfterClose) {
        this.editablePanel = editablePanel;
        this.focusAfterClose = focusAfterClose;
        this.saveAction = saveAction;
        this.closeAction = closeAction;
        this.setTitle(title);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.add(content, "Center");
        this.pack();
        this.setClosable(true);
        editablePanel.openModalDialog(this);
        if (this.getHeight() >= editablePanel.getHeight()) {
            this.setLocation(this.getLocation().x, 0);
        }
        SwingFrontend.focusFirstComponent(this);
    }

    @Override
    public void doDefaultCloseAction() {
        if (this.closeAction != null) {
            this.closeAction.action();
        } else {
            this.closeDialog();
        }
    }

    @Override
    public void setResizable(boolean resizable) {
        super.setResizable(resizable);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.isResizable()) {
            return new Dimension(Math.min(preferredSize.width + 30, this.editablePanel.getWidth()), Math.min(preferredSize.height + 70, this.editablePanel.getHeight()));
        }
        return new Dimension(Math.min(preferredSize.width, this.editablePanel.getWidth()), Math.min(preferredSize.height, this.editablePanel.getHeight()));
    }

    @Override
    public void closeDialog() {
        try {
            this.setClosed(true);
            this.focusAfterCloseComponent();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void focusAfterCloseComponent() {
        if (this.focusAfterClose != null) {
            this.focusAfterClose.requestFocus();
        }
    }

    public Action getSaveAction() {
        return this.saveAction;
    }

    @Override
    public void show() {
        super.show();
        SwingUtilities.invokeLater(() -> this.showModal());
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            SwingUtilities.invokeLater(() -> this.showModal());
        }
    }

    private void showModal() {
        EventQueue theQueue = this.getToolkit().getSystemEventQueue();
        while (this.isVisible()) {
            MouseEvent e;
            MouseEvent m;
            AWTEvent event = null;
            try {
                event = theQueue.getNextEvent();
            }
            catch (InterruptedException x) {
                LOG.warning(x.getLocalizedMessage());
                continue;
            }
            Object source = event.getSource();
            if (event instanceof MouseEvent && !this.contains((m = SwingUtilities.convertMouseEvent((Component)(e = (MouseEvent)event).getSource(), e, this)).getPoint()) && e.getID() != 506) continue;
            if (event instanceof ActiveEvent) {
                ((ActiveEvent)((Object)event)).dispatch();
                continue;
            }
            if (source instanceof Component) {
                ((Component)source).dispatchEvent(event);
                continue;
            }
            if (source instanceof MenuComponent) {
                ((MenuComponent)source).dispatchEvent(event);
                continue;
            }
            LOG.warning("Not dispatched: " + event);
        }
    }
}

