/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.impl.swing.Swing;
import org.minimalj.frontend.impl.swing.SwingFrame;
import org.minimalj.frontend.impl.swing.SwingTab;
import org.minimalj.frontend.impl.swing.component.SwingHtmlContent;
import org.minimalj.frontend.impl.swing.toolkit.SwingCheckBox;
import org.minimalj.frontend.impl.swing.toolkit.SwingComboBox;
import org.minimalj.frontend.impl.swing.toolkit.SwingFormContent;
import org.minimalj.frontend.impl.swing.toolkit.SwingHorizontalLayout;
import org.minimalj.frontend.impl.swing.toolkit.SwingImage;
import org.minimalj.frontend.impl.swing.toolkit.SwingList;
import org.minimalj.frontend.impl.swing.toolkit.SwingPasswordField;
import org.minimalj.frontend.impl.swing.toolkit.SwingReadOnlyTextField;
import org.minimalj.frontend.impl.swing.toolkit.SwingSwitchContent;
import org.minimalj.frontend.impl.swing.toolkit.SwingTable;
import org.minimalj.frontend.impl.swing.toolkit.SwingText;
import org.minimalj.frontend.impl.swing.toolkit.SwingTextAreaField;
import org.minimalj.frontend.impl.swing.toolkit.SwingTextField;
import org.minimalj.frontend.impl.swing.toolkit.SwingTextFieldAutocomplete;
import org.minimalj.frontend.impl.swing.toolkit.SwingTitle;
import org.minimalj.frontend.page.IDialog;
import org.minimalj.model.Rendering;
import org.minimalj.security.Subject;
import org.minimalj.util.resources.Resources;

public class SwingFrontend
extends Frontend {
    public static final Stack<SwingTab> browserStack = new Stack();

    @Override
    public Frontend.IComponent createText(String string) {
        return new SwingText(string);
    }

    @Override
    public Frontend.IComponent createText(org.minimalj.frontend.action.Action action) {
        return new SwingActionText(action);
    }

    @Override
    public Frontend.IComponent createText(Rendering rendering) {
        return new SwingText(rendering);
    }

    @Override
    public Frontend.IComponent createTitle(String string) {
        return new SwingTitle(string);
    }

    @Override
    public Frontend.Input<String> createReadOnlyTextField() {
        return new SwingReadOnlyTextField();
    }

    @Override
    public Frontend.Input<String> createTextField(int maxLength, String allowedCharacters, Frontend.Search<String> suggestionSearch, Frontend.InputComponentListener changeListener) {
        if (suggestionSearch == null) {
            return new SwingTextField(changeListener, maxLength, allowedCharacters);
        }
        return new SwingTextFieldAutocomplete(changeListener, suggestionSearch);
    }

    @Override
    public Frontend.PasswordField createPasswordField(Frontend.InputComponentListener changeListener, int maxLength) {
        return new SwingPasswordField(changeListener, maxLength);
    }

    @Override
    public Frontend.Input<String> createAreaField(int maxLength, String allowedCharacters, Frontend.InputComponentListener changeListener) {
        return new SwingTextAreaField(changeListener, maxLength, null);
    }

    @Override
    public Frontend.Input<byte[]> createImage(int size, Frontend.InputComponentListener changeListener) {
        return new SwingImage(size, changeListener);
    }

    @Override
    public Frontend.IList createList(org.minimalj.frontend.action.Action ... actions) {
        return new SwingList(actions);
    }

    @Override
    public <T> Frontend.Input<T> createComboBox(List<T> objects, Frontend.InputComponentListener changeListener) {
        return new SwingComboBox<T>(objects, changeListener);
    }

    @Override
    public Frontend.Input<Boolean> createCheckBox(Frontend.InputComponentListener changeListener, String text) {
        return new SwingCheckBox(changeListener, text);
    }

    @Override
    public Frontend.IComponent createComponentGroup(Frontend.IComponent ... components) {
        return new SwingHorizontalLayout(components);
    }

    @Override
    public Frontend.SwitchContent createSwitchContent() {
        return new SwingSwitchContent();
    }

    @Override
    public Frontend.FormContent createFormContent(int columns, int columnWidthPercentage) {
        return new SwingFormContent(columns, columnWidthPercentage);
    }

    public static void focusFirstComponent(JComponent jComponent) {
        if (jComponent.isShowing()) {
            SwingFrontend.focusFirstComponentNow(jComponent);
        } else {
            SwingFrontend.focusFirstComponentLater(jComponent);
        }
    }

    private static void focusFirstComponentNow(JComponent component) {
        FocusTraversalPolicy focusPolicy = component.getFocusTraversalPolicy();
        if (component instanceof JTextComponent || component instanceof JComboBox || component instanceof JCheckBox) {
            component.requestFocus();
        } else if (focusPolicy != null && focusPolicy.getFirstComponent(component) != null) {
            focusPolicy.getFirstComponent(component).requestFocus();
        } else {
            FocusManager.getCurrentManager().focusNextComponent(component);
        }
    }

    private static void focusFirstComponentLater(final JComponent component) {
        component.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                component.removeHierarchyListener(this);
                SwingFrontend.focusFirstComponent(component);
            }
        });
    }

    @Override
    public <T> Frontend.ITable<T> createTable(Object[] keys, boolean multiSelect, Frontend.TableActionListener<T> listener) {
        return new SwingTable<T>(keys, multiSelect, listener);
    }

    @Override
    public Frontend.IContent createHtmlContent(String htmlOrUrl) {
        return new SwingHtmlContent(htmlOrUrl);
    }

    @Override
    public <T> Frontend.Input<T> createLookup(Frontend.InputComponentListener changeListener, Frontend.Search<T> index, Object[] keys) {
        return new SwingLookup<T>(changeListener, index, keys);
    }

    public File showFileDialog(String title, String approveButtonText) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(title);
        if (0 == chooser.showDialog(this.getPageManager(), approveButtonText)) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static boolean verticallyGrowing(Component component) {
        if (component instanceof SwingList || component instanceof JTable || component instanceof SwingTextAreaField || component instanceof SwingImage) {
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component c : container.getComponents()) {
                if (!SwingFrontend.verticallyGrowing(c)) continue;
                return true;
            }
        }
        return false;
    }

    public static Action[] adaptActions(org.minimalj.frontend.action.Action[] actions) {
        Action[] swingActions = new Action[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            swingActions[i] = SwingFrontend.adaptAction(actions[i]);
        }
        return swingActions;
    }

    public static Action adaptAction(final org.minimalj.frontend.action.Action action) {
        final AbstractAction swingAction = new AbstractAction(action.getName()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingFrontend.runWithContext(() -> action.action());
            }
        };
        swingAction.putValue("ShortDescription", action.getDescription());
        action.setChangeListener(new Action.ActionChangeListener(){
            {
                this.update();
            }

            @Override
            public void change() {
                this.update();
            }

            protected void update() {
                swingAction.setEnabled(action.isEnabled());
                swingAction.putValue("ShortDescription", action.getDescription());
            }
        });
        return swingAction;
    }

    public static Icon getIcon(String resourceName) {
        String filename;
        URL url;
        if (Resources.isAvailable(resourceName) && (url = Swing.class.getResource(filename = Resources.getString(resourceName))) != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    public static void runWithContext(Runnable r) {
        try {
            browserStack.push(SwingFrame.getActiveWindow().getVisibleTab());
            Subject.setCurrent(SwingFrame.getActiveWindow().getSubject());
            r.run();
        }
        finally {
            Subject.setCurrent(null);
            browserStack.pop();
        }
    }

    public static boolean hasContext() {
        return !browserStack.isEmpty() && browserStack.peek() != null;
    }

    @Override
    public SwingTab getPageManager() {
        if (SwingFrontend.hasContext()) {
            return browserStack.peek();
        }
        if (SwingFrame.getActiveWindow() != null) {
            return SwingFrame.getActiveWindow().getVisibleTab();
        }
        return null;
    }

    private static class SwingLookup<T>
    extends JPanel
    implements Frontend.Input<T> {
        private static final long serialVersionUID = 1L;
        private final Frontend.InputComponentListener changeListener;
        private final Frontend.Search<T> search;
        private final Object[] keys;
        private final SwingLookupLabel actionLabel;
        private final SwingRemoveLabel removeLabel;
        private IDialog dialog;
        private T selectedObject;

        public SwingLookup(Frontend.InputComponentListener changeListener, Frontend.Search<T> search, Object[] keys) {
            super(new BorderLayout());
            this.changeListener = changeListener;
            this.search = search;
            this.keys = keys;
            this.actionLabel = new SwingLookupLabel();
            this.removeLabel = new SwingRemoveLabel();
            this.add((Component)this.actionLabel, "Center");
            this.add((Component)this.removeLabel, "After");
        }

        @Override
        public void setValue(T value) {
            this.selectedObject = value;
            this.display();
        }

        protected void display() {
            if (this.selectedObject instanceof Rendering) {
                Rendering rendering = (Rendering)this.selectedObject;
                this.actionLabel.setText(rendering.render(Rendering.RenderType.PLAIN_TEXT));
            } else if (this.selectedObject != null) {
                this.actionLabel.setText(this.selectedObject.toString());
            } else {
                this.actionLabel.setText("[+]");
            }
        }

        @Override
        public T getValue() {
            return this.selectedObject;
        }

        @Override
        public void setEditable(boolean editable) {
            this.actionLabel.setEnabled(editable);
            this.removeLabel.setEnabled(editable);
        }

        private class LookupClickListener
        implements Frontend.TableActionListener<T> {
            private LookupClickListener() {
            }

            @Override
            public void action(T selectedObject) {
                SwingLookup.this.setValue(selectedObject);
                SwingLookup.this.dialog.closeDialog();
                SwingLookup.this.changeListener.changed(SwingLookup.this);
            }
        }

        private class SwingRemoveLabel
        extends JLabel {
            private static final long serialVersionUID = 1L;

            public SwingRemoveLabel() {
                super("[x]");
                this.setForeground(Color.BLUE);
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        SwingLookup.this.setValue(null);
                        SwingLookup.this.changeListener.changed(SwingLookup.this);
                    }
                });
            }
        }

        private class SwingLookupLabel
        extends JLabel {
            private static final long serialVersionUID = 1L;

            public SwingLookupLabel() {
                this.setForeground(Color.BLUE);
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        SwingLookup.this.dialog = Frontend.showSearchDialog(SwingLookup.this.search, SwingLookup.this.keys, new LookupClickListener());
                    }
                });
            }
        }
    }

    public static class SwingActionText
    extends JLabel
    implements Frontend.IComponent {
        private static final long serialVersionUID = 1L;

        public SwingActionText(final org.minimalj.frontend.action.Action action) {
            this.setText(action.getName());
            this.setForeground(Color.BLUE);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SwingFrontend.runWithContext(() -> action.action());
                }
            });
        }
    }
}

