/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentInputMapUIResource;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.impl.swing.toolkit.ScrollablePanel;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;

public class SwingEditorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public SwingEditorPanel(Frontend.IContent content, org.minimalj.frontend.action.Action[] actions) {
        super(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(new ScrollablePanel((Component)((Object)content)));
        scrollPane.setBorder(new TopBottomBorder(scrollPane.getBorder()));
        this.add((Component)scrollPane, "Center");
        ButtonBar buttonBar = new ButtonBar(SwingFrontend.adaptActions(actions));
        this.add((Component)buttonBar, "South");
    }

    private static void installAccelerator(Action action, JButton button) {
        if (action.getValue("AcceleratorKey") instanceof KeyStroke) {
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            InputMap windowInputMap = SwingUtilities.getUIInputMap(button, 2);
            if (windowInputMap == null) {
                windowInputMap = new ComponentInputMapUIResource(button);
                SwingUtilities.replaceUIInputMap(button, 2, windowInputMap);
            }
            windowInputMap.put(keyStroke, keyStroke.toString());
            button.getActionMap().put(keyStroke.toString(), action);
        }
    }

    private static class ButtonBar
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ButtonBar(Action ... actions) {
            super(new FlowLayout(2, 5, 0));
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 2));
            for (Action action : actions) {
                this.add(new JButton(action));
            }
        }
    }

    private class TopBottomBorder
    implements Border {
        private final Border delegate;

        public TopBottomBorder(Border delegate) {
            this.delegate = delegate;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintBorder(c, g, x, y, width, height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets insetsOfDelegate = this.delegate.getBorderInsets(c);
            Insets insets = new Insets(insetsOfDelegate.top, 0, insetsOfDelegate.bottom, 0);
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return this.delegate.isBorderOpaque();
        }
    }
}

