/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.toolkit;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.minimalj.application.DevMode;
import org.minimalj.frontend.Frontend;
import org.minimalj.model.Rendering;
import org.minimalj.util.CloneHelper;

public class SwingComboBox<T>
extends JComboBox<T>
implements Frontend.Input<T> {
    private static final long serialVersionUID = 1L;
    private final Frontend.InputComponentListener listener;
    private final NullableComboBoxModel<T> model;

    public SwingComboBox(List<T> objects, Frontend.InputComponentListener listener) {
        this.listener = listener;
        this.setRenderer(new CodeItemRenderer(this.getRenderer()));
        this.addItemListener(new ComboBoxChangeListener());
        this.setInheritsPopupMenu(true);
        this.model = new NullableComboBoxModel<T>(objects);
        this.setModel(this.model);
    }

    @Override
    public void setValue(T object) {
        this.model.setObject(object);
    }

    @Override
    public T getValue() {
        return this.model.getSelectedObject();
    }

    @Override
    public void setEditable(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public int getSelectedIndex() {
        if (this.getSelectedItem() == null && this.getModel().getElementAt(0) == null) {
            return 0;
        }
        return super.getSelectedIndex();
    }

    private class CodeItemRenderer
    implements ListCellRenderer<T> {
        private final ListCellRenderer<? super T> delegate;

        public CodeItemRenderer(ListCellRenderer<? super T> listCellRenderer) {
            this.delegate = listCellRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof Rendering) {
                Rendering renderingValue = (Rendering)value;
                if (component instanceof JLabel) {
                    String text = renderingValue.render(Rendering.RenderType.PLAIN_TEXT);
                    ((JLabel)component).setText(text);
                    String tooltip = renderingValue.renderTooltip(Rendering.RenderType.PLAIN_TEXT);
                    if (tooltip != null) {
                        ((JComponent)component).setToolTipText(tooltip);
                    }
                } else {
                    if (DevMode.isActive()) {
                        throw new RuntimeException("Cell component expected to be a JLabel");
                    }
                    Logger.getLogger(this.getClass().getName()).warning("Cell component expected to be a JLabel");
                }
            }
            return component;
        }
    }

    private static class NullableComboBoxModel<T>
    extends AbstractListModel<T>
    implements ComboBoxModel<T> {
        private static final long serialVersionUID = 1L;
        private final List<T> objects;
        private T setObject;
        private T selectedObject;
        private boolean setObjectInObjects;

        public NullableComboBoxModel(List<T> objects) {
            this.objects = objects;
        }

        @Override
        public int getSize() {
            if (this.setObjectInObjects) {
                return this.objects.size() + 1;
            }
            return this.objects.size() + 2;
        }

        @Override
        public T getElementAt(int index) {
            if (this.setObjectInObjects) {
                if (index == 0) {
                    return null;
                }
                return this.objects.get(index - 1);
            }
            if (index == 0) {
                return null;
            }
            if (index == 1) {
                return this.setObject;
            }
            return this.objects.get(index - 2);
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
                this.selectedObject = anObject;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }

        protected T getSelectedObject() {
            return this.selectedObject;
        }

        protected void setObject(T object) {
            try {
                this.setObject = CloneHelper.clone(object);
            }
            catch (Exception x) {
                this.setObject = object;
            }
            this.selectedObject = object;
            this.updateSetObjectInObjects();
            this.fireContentsChanged(this, -1, -1);
        }

        private void updateSetObjectInObjects() {
            this.setObjectInObjects = this.setObject == null || this.objects.contains(this.setObject);
        }
    }

    public class ComboBoxChangeListener
    implements ItemListener {
        private void fireChangeEvent() {
            SwingComboBox.this.listener.changed(SwingComboBox.this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.fireChangeEvent();
        }
    }
}

