/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.lookAndFeel;

import java.awt.Color;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.minimalj.frontend.impl.swing.lookAndFeel.MetalThemeProvider;

public class PrintLookAndFeel
extends MetalLookAndFeel
implements MetalThemeProvider {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(PrintLookAndFeel.class.getName());
    static Properties properties = new Properties();

    @Override
    public String getName() {
        return properties.getProperty("name");
    }

    @Override
    public String getDescription() {
        return properties.getProperty("description");
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        BorderUIResource lineBorder = new BorderUIResource(new MatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
        BorderUIResource textBorder = new BorderUIResource(new CompoundBorder(lineBorder, new BasicBorders.MarginBorder()));
        Object[] defaults = new Object[]{"ComboBox.selectionForeground", PrintLookAndFeel.getHighlightedTextColor(), "Panel.font", PrintLookAndFeel.getControlTextFont(), "ToolTip.border", lineBorder, "TitledBorder.border", lineBorder, "TextField.border", textBorder, "PasswordField.border", textBorder, "TextArea.border", textBorder, "TextPane.border", textBorder, "EditorPane.border", textBorder, "Button.border", lineBorder};
        table.putDefaults(defaults);
    }

    @Override
    public MetalTheme getMetalTheme() {
        return new MetalTheme();
    }

    static {
        try {
            properties.load(PrintLookAndFeel.class.getResourceAsStream("PrintLookAndFeel.properties"));
        }
        catch (IOException ioe) {
            logger.warning("Could not load PrintLookAndFeel.properties.");
        }
    }

    public static class MetalTheme
    extends DefaultMetalTheme {
        private FontUIResource font;

        private static ColorUIResource getColor(String key) {
            return new ColorUIResource(Integer.parseInt(properties.getProperty(key), 16));
        }

        public MetalTheme() {
            String fontName = properties.getProperty("fontName", "Dialog");
            int fontSize = 12;
            try {
                fontSize = Integer.parseInt(properties.getProperty("fontSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.font = new FontUIResource(fontName, 0, fontSize);
        }

        @Override
        public ColorUIResource getMenuBackground() {
            return this.getWhite();
        }

        @Override
        public ColorUIResource getMenuDisabledForeground() {
            return this.getWhite();
        }

        @Override
        public ColorUIResource getMenuForeground() {
            return this.getBlack();
        }

        @Override
        protected ColorUIResource getWhite() {
            return MetalTheme.getColor("backgroundColor");
        }

        @Override
        public ColorUIResource getControl() {
            return MetalTheme.getColor("backgroundColor");
        }

        @Override
        protected ColorUIResource getBlack() {
            return MetalTheme.getColor("foregroundColor");
        }

        @Override
        protected ColorUIResource getPrimary1() {
            return MetalTheme.getColor("primaryColor1");
        }

        @Override
        protected ColorUIResource getPrimary2() {
            return MetalTheme.getColor("primaryColor2");
        }

        @Override
        protected ColorUIResource getPrimary3() {
            return MetalTheme.getColor("primaryColor3");
        }

        @Override
        protected ColorUIResource getSecondary1() {
            return MetalTheme.getColor("secondaryColor1");
        }

        @Override
        protected ColorUIResource getSecondary2() {
            return MetalTheme.getColor("secondaryColor2");
        }

        @Override
        protected ColorUIResource getSecondary3() {
            return MetalTheme.getColor("secondaryColor3");
        }

        protected ColorUIResource getSelectionForeground() {
            return MetalTheme.getColor("selectionForeground");
        }

        protected ColorUIResource getSelectionBackground() {
            return MetalTheme.getColor("selectionBackground");
        }

        @Override
        public ColorUIResource getMenuSelectedBackground() {
            return this.getSelectionBackground();
        }

        @Override
        public ColorUIResource getMenuSelectedForeground() {
            return this.getSelectionForeground();
        }

        @Override
        public ColorUIResource getTextHighlightColor() {
            return this.getSelectionBackground();
        }

        @Override
        public ColorUIResource getHighlightedTextColor() {
            return this.getSelectionForeground();
        }

        @Override
        public FontUIResource getControlTextFont() {
            return this.font;
        }

        @Override
        public FontUIResource getMenuTextFont() {
            return this.font;
        }

        @Override
        public FontUIResource getSubTextFont() {
            return this.font;
        }

        @Override
        public FontUIResource getSystemTextFont() {
            return this.font;
        }

        @Override
        public FontUIResource getUserTextFont() {
            return this.font;
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.font;
        }
    }
}

