/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.component;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SwingDecoration
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final boolean SHOW_MINIMIZE = true;
    public static final boolean HIDE_MINIMIZE = false;
    private final Component content;
    private final ActionListener closeListener;
    private JLabel titleLabel;

    public SwingDecoration(String title, Component content, boolean minimize, ActionListener closeListener) {
        super(new BorderLayout());
        this.content = content;
        this.closeListener = closeListener;
        this.add(this.createBar(title, minimize), "North");
        content.setVisible(true);
        this.add(content, "Center");
    }

    public void setContentVisible() {
        this.content.setVisible(true);
        this.content.getParent().revalidate();
        this.content.getParent().repaint();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    private Component createBar(String title, boolean minimize) {
        JButton button;
        JMenuBar bar = new JMenuBar();
        this.titleLabel = new JLabel(title);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 0));
        bar.add(this.titleLabel);
        bar.add(Box.createHorizontalGlue());
        if (minimize) {
            button = SwingDecoration.createDecorationButton(Part.WP_MINBUTTON);
            bar.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingDecoration.this.content.setVisible(!SwingDecoration.this.content.isShowing());
                    SwingDecoration.this.content.getParent().revalidate();
                    SwingDecoration.this.content.getParent().repaint();
                }
            });
        }
        if (this.closeListener != null) {
            button = SwingDecoration.createDecorationButton(Part.WP_CLOSEBUTTON);
            bar.add(button);
            button.addActionListener(this.closeListener);
        }
        bar.setPreferredSize(bar.getMinimumSize());
        return bar;
    }

    public static JButton createDecorationButton(Part part) {
        JButton button = new JButton(new DecorationButtonIcon(part));
        button.setFocusPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setMaximumSize(new Dimension(button.getIcon().getIconWidth(), button.getIcon().getIconHeight()));
        button.setPreferredSize(new Dimension(button.getIcon().getIconWidth(), button.getIcon().getIconHeight()));
        return button;
    }

    public void minimize() {
        if (this.content.isVisible()) {
            this.content.setVisible(false);
            this.content.getParent().revalidate();
            this.content.getParent().repaint();
        }
    }

    public static class DecorationButtonIcon
    implements Icon {
        private Part part;

        public DecorationButtonIcon(Part part) {
            this.part = part;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x0, int y0) {
            float inset;
            Graphics2D g2 = (Graphics2D)g;
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            g2.setColor(UIManager.getColor("menuText"));
            g2.setStroke(new BasicStroke(Math.max((float)height / 12.0f, 1.4f)));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            float x = inset = (float)width / 20.0f + (float)(this.part == Part.WP_CLOSEBUTTON || this.part == Part.WP_MINBUTTON ? 4 : 5);
            float y = inset;
            float w = (float)width - 2.0f * inset;
            if (this.part == Part.WP_CLOSEBUTTON) {
                g2.draw(new Line2D.Float(x, y, x + w, y + w));
                g2.draw(new Line2D.Float(x + w, y, x, y + w));
            } else if (this.part == Part.NEXT) {
                g2.draw(new Line2D.Float(x, y, x + w, y + w / 2.0f));
                g2.draw(new Line2D.Float(x + w, y + w / 2.0f, x, y + w));
            } else if (this.part == Part.PREV) {
                g2.draw(new Line2D.Float(x, y + w / 2.0f, x + w, y + w));
                g2.draw(new Line2D.Float(x + w, y, x, y + w / 2.0f));
            } else if (this.part == Part.WP_MINBUTTON) {
                g2.draw(new Line2D.Float(x + w / 3.0f, y + w, x + w, y + w));
            }
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static enum Part {
        WP_CLOSEBUTTON,
        WP_MINBUTTON,
        PREV,
        NEXT;

    }
}

