/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;

public class SwingCaption
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JLabel captionLabel;

    public SwingCaption(Component component, String caption) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.captionLabel = new CaptionLabel(caption);
        this.add((Component)this.captionLabel, "North");
        this.add(component, "Center");
        ((JComponent)component).putClientProperty(SwingCaption.class, this);
    }

    public void setValidationMessages(List<String> validationMessages) {
        if (!validationMessages.isEmpty()) {
            this.captionLabel.setIcon(SwingFrontend.getIcon("FieldError.icon"));
            StringBuilder s = new StringBuilder();
            s.append("<html>");
            for (int i = 0; i < validationMessages.size(); ++i) {
                s.append(validationMessages.get(i));
                if (i >= validationMessages.size() - 1) continue;
                s.append("<br>");
            }
            s.append("</html>");
            this.captionLabel.setToolTipText(s.toString());
        } else {
            this.captionLabel.setIcon(null);
            this.captionLabel.setToolTipText(null);
        }
    }

    private static class CaptionLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private static WeakHashMap<Font, Font> boldFonts = new WeakHashMap();

        public CaptionLabel(String caption) {
            super(caption);
            this.setHorizontalTextPosition(10);
        }

        @Override
        public void setUI(LabelUI ui) {
            if (this.getFont() != null) {
                this.setFont(null);
            }
            super.setUI(ui);
            Font font = this.getFont();
            Font boldFont = boldFonts.get(font);
            if (boldFont == null) {
                float fontSize = font.getSize();
                fontSize = (int)(fontSize * 4.0f / 5.0f + 1.0f);
                boldFont = font.deriveFont(fontSize).deriveFont(1);
                boldFonts.put(font, boldFont);
            }
            this.setFont(boldFont);
        }
    }
}

