/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing.component;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class EditablePanel
extends JDesktopPane {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(EditablePanel.class.getName());
    private List<JInternalFrame> openFrames = new ArrayList<JInternalFrame>();
    private int lockCount = 0;
    private InternalFrameListener listener = new InternalFrameAdapter(){

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            EditablePanel.this.closeModalDialog(e.getInternalFrame());
            e.getInternalFrame().removeInternalFrameListener(this);
        }
    };

    public EditablePanel() {
        this.setOpaque(false);
        this.setLayout(null);
        this.setFocusCycleRoot(false);
        this.setDesktopManager(new BoundedDesktopManager());
    }

    public void setContent(JComponent content) {
        JInternalFrame frame = new JInternalFrame(""){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateUI() {
                super.updateUI();
                this.setBorder(null);
                BasicInternalFrameUI bi = (BasicInternalFrameUI)this.getUI();
                bi.setNorthPane(null);
            }
        };
        frame.setLayout(new BorderLayout());
        frame.add((Component)content, "Center");
        this.add(frame);
        frame.setVisible(true);
        try {
            frame.setMaximum(true);
        }
        catch (PropertyVetoException e) {
            LOG.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    public void openModalDialog(JInternalFrame internalFrame) {
        if (this.openFrames.contains(internalFrame)) {
            throw new IllegalArgumentException("Dialog already open");
        }
        this.openFrames.add(internalFrame);
        this.add(internalFrame);
        internalFrame.addInternalFrameListener(this.listener);
        this.arrangeFrames();
        internalFrame.setVisible(true);
        internalFrame.requestFocus();
    }

    public void lock() {
        ++this.lockCount;
        EditablePanel.setCursorRecursive(this, Cursor.getPredefinedCursor(3));
        EventQueue theQueue = this.getToolkit().getSystemEventQueue();
        while (this.lockCount > 0) {
            AWTEvent event = null;
            try {
                event = theQueue.getNextEvent();
            }
            catch (InterruptedException x) {
                LOG.warning(x.getLocalizedMessage());
                continue;
            }
            Object source = event.getSource();
            if (event instanceof MouseEvent) continue;
            if (event instanceof ActiveEvent) {
                ((ActiveEvent)((Object)event)).dispatch();
                continue;
            }
            if (source instanceof Component) {
                ((Component)source).dispatchEvent(event);
                continue;
            }
            if (source instanceof MenuComponent) {
                ((MenuComponent)source).dispatchEvent(event);
                continue;
            }
            LOG.warning("Not dispatched: " + event);
        }
        EditablePanel.setCursorRecursive(this, Cursor.getPredefinedCursor(0));
    }

    private static void setCursorRecursive(Component component, Cursor cursor) {
        component.setCursor(cursor);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component c : container.getComponents()) {
                EditablePanel.setCursorRecursive(c, cursor);
            }
        }
    }

    public void unlock() {
        --this.lockCount;
        if (this.lockCount < 1) {
            EventQueue theQueue = this.getToolkit().getSystemEventQueue();
            theQueue.postEvent(new ActionEvent(this, 0, "unlock"));
        }
    }

    public boolean tryToCloseDialogs() {
        for (int i = this.openFrames.size() - 1; i >= 0; --i) {
            JInternalFrame frame = this.openFrames.get(i);
            frame.doDefaultCloseAction();
            if (!frame.isVisible()) continue;
            return false;
        }
        return true;
    }

    private void closeModalDialog(JInternalFrame internalFrame) {
        if (!this.openFrames.contains(internalFrame)) {
            throw new IllegalArgumentException("Dialog to close not open");
        }
        this.openFrames.remove(internalFrame);
        internalFrame.setVisible(false);
        this.remove(internalFrame);
    }

    private void arrangeFrames() {
        JInternalFrame newFrame = this.openFrames.get(this.openFrames.size() - 1);
        if (this.openFrames.size() == 1) {
            if (this.shouldCompleteFill(newFrame)) {
                try {
                    newFrame.setMaximum(true);
                    newFrame.setBorder(null);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            this.openFrames.get(0).setLocation(this.getWidth() / 2 - this.openFrames.get(0).getWidth() / 2 - 40, 50);
        } else {
            JInternalFrame lastFrame = this.openFrames.get(this.openFrames.size() - 2);
            newFrame.setLocation(lastFrame.getX() + 50, lastFrame.getY() + 40);
            if (newFrame.getX() + newFrame.getWidth() > this.getWidth()) {
                newFrame.setSize(this.getWidth() - newFrame.getX(), newFrame.getHeight());
            }
        }
    }

    private boolean shouldCompleteFill(JInternalFrame frame) {
        return frame.getWidth() * 2 > this.getWidth() && frame.getHeight() * 2 > this.getHeight();
    }

    public class BoundedDesktopManager
    extends DefaultDesktopManager {
        private static final long serialVersionUID = 1L;

        @Override
        public void beginDraggingFrame(JComponent f) {
        }

        @Override
        public void beginResizingFrame(JComponent f, int direction) {
        }

        @Override
        public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            boolean didResize;
            boolean bl = didResize = f.getWidth() != newWidth || f.getHeight() != newHeight;
            if (!this.inBounds((JInternalFrame)f, newX, newY, newWidth, newHeight)) {
                Container parent = f.getParent();
                Dimension parentSize = parent.getSize();
                int boundedX = (int)Math.min((double)Math.max(0, newX), parentSize.getWidth() - (double)newWidth);
                int boundedY = (int)Math.min((double)Math.max(0, newY), parentSize.getHeight() - (double)newHeight);
                f.setBounds(boundedX, boundedY, newWidth, newHeight);
            } else {
                f.setBounds(newX, newY, newWidth, newHeight);
            }
            if (didResize) {
                f.validate();
            }
        }

        protected boolean inBounds(JInternalFrame f, int newX, int newY, int newWidth, int newHeight) {
            if (newX < 0 || newY < 0) {
                return false;
            }
            if (newX + newWidth > f.getDesktopPane().getWidth()) {
                return false;
            }
            return newY + newHeight <= f.getDesktopPane().getHeight();
        }
    }
}

