/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.minimalj.application.Application;
import org.minimalj.frontend.impl.swing.SwingTab;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;
import org.minimalj.frontend.page.Page;

public class SwingToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    private final SwingTab tab;
    private JTextField textFieldSearch;

    public SwingToolBar(SwingTab tab) {
        this.tab = tab;
        this.setFloatable(false);
        this.fillToolBar();
    }

    protected void fillToolBar() {
        this.fillToolBarNavigation();
        this.fillToolBarRefresh();
        this.add(Box.createHorizontalGlue());
        this.fillToolBarSearch();
    }

    protected void fillToolBarNavigation() {
        this.add(this.tab.previousAction);
        this.add(this.tab.nextAction);
    }

    protected void fillToolBarRefresh() {
        this.add(this.tab.refreshAction);
    }

    protected void fillToolBarSearch() {
        this.textFieldSearch = new JTextField();
        this.textFieldSearch.setPreferredSize(new Dimension(200, this.textFieldSearch.getPreferredSize().height));
        this.textFieldSearch.setMaximumSize(this.textFieldSearch.getPreferredSize());
        this.add(this.textFieldSearch);
        Dimension rightFillerDimension = new Dimension(6, 0);
        this.add(new Box.Filler(rightFillerDimension, rightFillerDimension, rightFillerDimension));
        if (Application.getInstance().hasSearchPages()) {
            this.textFieldSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingFrontend.runWithContext(() -> {
                        String query = SwingToolBar.this.textFieldSearch.getText();
                        Page page = Application.getInstance().createSearchPage(query);
                        SwingToolBar.this.tab.show(page);
                    });
                }
            });
        } else {
            this.textFieldSearch.setEnabled(false);
        }
    }

    void onHistoryChanged() {
    }
}

