/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing;

import javax.swing.SwingUtilities;
import org.minimalj.backend.Backend;
import org.minimalj.frontend.impl.swing.SwingTab;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;
import org.minimalj.transaction.Transaction;

public class SwingBackend
extends Backend {
    private final Backend delegate;

    public SwingBackend(Backend delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> T doExecute(Transaction<T> transaction) {
        if (!SwingFrontend.hasContext() || !SwingUtilities.isEventDispatchThread()) {
            return this.delegate.doExecute(transaction);
        }
        SwingTab swingTab = (SwingTab)SwingFrontend.getInstance().getPageManager();
        ExecuteThread<T> thread = new ExecuteThread<T>(swingTab, transaction);
        thread.start();
        swingTab.lock();
        if (thread.getException() != null) {
            throw new RuntimeException(thread.getException());
        }
        return thread.getResult();
    }

    @Override
    public boolean isInTransaction() {
        return this.delegate.isInTransaction();
    }

    private class ExecuteThread<T>
    extends Thread {
        private final SwingTab swingTab;
        private final Transaction<T> transaction;
        private T result;
        private Exception exception;

        public ExecuteThread(SwingTab swingTab, Transaction<T> transaction) {
            this.swingTab = swingTab;
            this.transaction = transaction;
        }

        @Override
        public void run() {
            try {
                this.result = SwingBackend.this.delegate.doExecute(this.transaction);
            }
            catch (Exception x) {
                this.exception = x;
            }
            finally {
                this.swingTab.unlock();
            }
        }

        public T getResult() {
            return this.result;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

