/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.minimalj.model.Code;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.properties.FlatProperties;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.Codes;
import org.minimalj.util.IdUtils;
import org.minimalj.util.LoggingRuntimeException;

public class PreferencesHelper {
    private static final Logger logger = Logger.getLogger(PreferencesHelper.class.getName());

    public static void load(Object data) {
        Preferences preferences = Preferences.userNodeForPackage(data.getClass()).node(data.getClass().getSimpleName());
        PreferencesHelper.load(preferences, data);
    }

    public static void load(Preferences preferences, Object data) {
        for (Map.Entry<String, PropertyInterface> entry : FlatProperties.getProperties(data.getClass()).entrySet()) {
            Object presetValue;
            String key = entry.getKey();
            Class<?> clazz = entry.getValue().getClazz();
            Object value = null;
            if (String.class.equals(clazz)) {
                presetValue = (String)FlatProperties.getValue(data, key);
                value = preferences.get(key, (String)presetValue);
            } else if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
                presetValue = (Integer)FlatProperties.getValue(data, key);
                value = preferences.getInt(key, presetValue != null ? (Integer)presetValue : 0);
            } else if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
                presetValue = (Boolean)FlatProperties.getValue(data, key);
                value = preferences.getBoolean(key, presetValue != null ? (Boolean)presetValue : false);
            } else if (clazz == LocalDate.class) {
                presetValue = (LocalDate)FlatProperties.getValue(data, key);
                String formattedDate = preferences.get(key, presetValue != null ? ((LocalDate)presetValue).toString() : null);
                value = LocalDate.parse(formattedDate, DateTimeFormatter.ISO_DATE);
            } else if (Enum.class.isAssignableFrom(clazz)) {
                presetValue = (Enum)FlatProperties.getValue(data, key);
                int ordinal = preferences.getInt(key, presetValue != null ? ((Enum)presetValue).ordinal() : 0);
                value = EnumUtils.valueList(presetValue.getClass()).get(ordinal);
            } else if (Code.class.isAssignableFrom(clazz)) {
                Class<?> clazz2;
                Object id;
                presetValue = (Code)FlatProperties.getValue(data, key);
                PropertyInterface property = FlatProperties.getProperty(clazz, "id");
                if (property.getClazz() == String.class) {
                    id = preferences.get(key, null);
                    if (id != null) {
                        clazz2 = clazz;
                        value = Codes.findCode(clazz2, (String)id);
                    } else {
                        value = presetValue;
                    }
                } else if (property.getClazz() == Integer.class) {
                    id = preferences.getInt(key, 0);
                    if ((Integer)id != 0) {
                        clazz2 = clazz;
                        value = Codes.findCode(clazz2, (Integer)id);
                    } else {
                        value = presetValue;
                    }
                }
            } else {
                logger.warning("Preference Field with unsupported Class: " + key + " of class " + clazz.getSimpleName() + " in " + data.getClass().getSimpleName());
            }
            FlatProperties.set(data, key, value);
        }
    }

    public static void save(Object object) {
        Preferences preferences = Preferences.userNodeForPackage(object.getClass()).node(object.getClass().getSimpleName());
        PreferencesHelper.save(preferences, object);
    }

    public static void save(Preferences preferences, Object object) {
        for (Map.Entry<String, PropertyInterface> entry : FlatProperties.getProperties(object.getClass()).entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue().getValue(object);
            if (value == null) {
                preferences.remove(key);
                continue;
            }
            if (value instanceof Boolean) {
                preferences.putBoolean(key, (Boolean)value);
                continue;
            }
            if (value instanceof String) {
                preferences.put(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                preferences.putInt(key, (Integer)value);
                continue;
            }
            if (value instanceof Enum) {
                Enum e = (Enum)value;
                preferences.putInt(key, e.ordinal());
                continue;
            }
            if (value instanceof LocalDate) {
                preferences.put(key, ((LocalDate)value).toString());
                continue;
            }
            if (value instanceof Code) {
                Object id = IdUtils.getId(value);
                if (id instanceof String) {
                    preferences.put(key, (String)id);
                    continue;
                }
                if (id instanceof Integer) {
                    preferences.putInt(key, (Integer)id);
                    continue;
                }
                throw new IllegalArgumentException("Only codes with String or Integer ids are allowed for preferences object");
            }
            throw new IllegalArgumentException();
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new LoggingRuntimeException(e, logger, e.getMessage());
        }
    }
}

