/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JPanel;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.action.ActionGroup;
import org.minimalj.frontend.impl.swing.toolkit.SwingFrontend;
import org.minimalj.frontend.impl.swing.toolkit.SwingText;

public class NavigationTree
extends JPanel {
    private static final long serialVersionUID = 1L;

    public NavigationTree(List<Action> actions) {
        super(new VerticalLayoutManager());
        for (Action action : actions) {
            if (action instanceof ActionGroup) {
                this.add(new SwingText(action.getName()));
                ActionGroup actionGroup = (ActionGroup)action;
                this.add(new NavigationTree(actionGroup.getItems()));
                continue;
            }
            this.add(new SwingFrontend.SwingActionText(action));
        }
    }

    public static class VerticalLayoutManager
    implements LayoutManager {
        private Dimension preferredSize = new Dimension(100, 0);

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return this.preferredSize;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return this.preferredSize;
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = 0;
            int x = 10;
            int width = parent.getWidth();
            for (Component component : parent.getComponents()) {
                int height = component.getPreferredSize().height;
                component.setBounds(x, y, width, height);
                y += 3 + height;
            }
            this.preferredSize = new Dimension(100, y);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

