/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.nanoserver;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.NanoWSD;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.minimalj.application.Configuration;
import org.minimalj.frontend.impl.json.JsonPageManager;
import org.minimalj.frontend.impl.json.JsonSessionManager;
import org.minimalj.frontend.impl.nanoserver.MjWebDaemon;

public class MjWebSocketDaemon
extends NanoWSD {
    private static final Logger logger = Logger.getLogger(MjWebSocketDaemon.class.getName());
    private JsonSessionManager sessionManager = new JsonSessionManager();

    public MjWebSocketDaemon(int port, boolean secure) {
        super(port);
        if (secure) {
            try {
                String keyAndTrustStoreClasspathPath = Configuration.get("MjKeystore");
                char[] passphrase = Configuration.get("MjKeystorePassphrase").toCharArray();
                this.makeSecure(MjWebSocketDaemon.makeSSLSocketFactory((String)keyAndTrustStoreClasspathPath, (char[])passphrase), null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected NanoWSD.WebSocket openWebSocket(NanoHTTPD.IHTTPSession handshake) {
        return new MjWebSocket(handshake);
    }

    public NanoHTTPD.Response serve(String uri, NanoHTTPD.Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) {
        return MjWebDaemon.serve(this.sessionManager, uri, method, headers, parms, files);
    }

    public class MjWebSocket
    extends NanoWSD.WebSocket {
        private JsonPageManager pageManager;

        public MjWebSocket(NanoHTTPD.IHTTPSession handshakeRequest) {
            super(handshakeRequest);
            this.pageManager = new JsonPageManager();
        }

        protected void onOpen() {
        }

        protected void onMessage(NanoWSD.WebSocketFrame message) {
            String result = this.pageManager.handle(message.getTextPayload());
            try {
                this.send(result);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Send response failed", e);
            }
        }

        protected void onPong(NanoWSD.WebSocketFrame pong) {
        }

        protected void onClose(NanoWSD.WebSocketFrame.CloseCode code, String reason, boolean initiatedByRemote) {
            logger.fine("Close " + reason + " / " + initiatedByRemote);
        }

        protected void onException(IOException exception) {
        }
    }
}

