/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.impl.nanoserver;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.minimalj.application.Application;
import org.minimalj.application.Configuration;
import org.minimalj.frontend.impl.json.JsonFrontend;
import org.minimalj.frontend.impl.json.JsonSessionManager;
import org.minimalj.util.resources.Resources;

public class MjWebDaemon
extends NanoHTTPD {
    private static final Logger logger = Logger.getLogger(MjWebDaemon.class.getName());
    private JsonSessionManager sessionManager = new JsonSessionManager();

    public MjWebDaemon(int port, boolean secure) {
        super(port);
        if (secure) {
            try {
                String keyAndTrustStoreClasspathPath = Configuration.get("MjKeystore");
                char[] passphrase = Configuration.get("MjKeystorePassphrase").toCharArray();
                this.makeSecure(MjWebDaemon.makeSSLSocketFactory((String)keyAndTrustStoreClasspathPath, (char[])passphrase), null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public NanoHTTPD.Response serve(String uri, NanoHTTPD.Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) {
        return MjWebDaemon.serve(this.sessionManager, uri, method, headers, parms, files);
    }

    static NanoHTTPD.Response serve(JsonSessionManager sessionManager, String uri, NanoHTTPD.Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) {
        String postfix;
        String mimeType;
        if ((uri = uri.substring(uri.lastIndexOf(47), uri.length())).equals("/")) {
            String htmlTemplate = JsonFrontend.getHtmlTemplate();
            Locale locale = MjWebDaemon.getLocale(headers.get("accept-language"));
            String html = JsonFrontend.fillPlaceHolder(htmlTemplate, locale);
            return MjWebDaemon.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/html", (String)html);
        }
        if ("/ajax_request.xml".equals(uri)) {
            String data = files.get("postData");
            String result = sessionManager.handle(data);
            return MjWebDaemon.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/xml", (String)result);
        }
        if ("/application.png".equals(uri)) {
            return MjWebDaemon.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"png", (InputStream)Application.getInstance().getIcon());
        }
        int index = uri.lastIndexOf(46);
        if (index > -1 && index < uri.length() - 1 && (mimeType = Resources.getMimeType(postfix = uri.substring(index + 1))) != null) {
            InputStream inputStream = MjWebDaemon.class.getResourceAsStream(uri);
            return MjWebDaemon.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mimeType, (InputStream)inputStream);
        }
        logger.warning("Could not serve: " + uri);
        return MjWebDaemon.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/html", (String)(uri + " not found"));
    }

    private static Locale getLocale(String userLocale) {
        Iterator<Locale.LanguageRange> iterator;
        List<Locale.LanguageRange> ranges = Locale.LanguageRange.parse(userLocale);
        if (ranges != null && (iterator = ranges.iterator()).hasNext()) {
            Locale.LanguageRange languageRange = iterator.next();
            String localeString = languageRange.getRange();
            Locale locale = Locale.forLanguageTag(localeString);
            return locale;
        }
        return null;
    }
}

